/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Variation;
import org.moeaframework.core.operator.CompoundVariation;
import org.moeaframework.core.operator.StandardOperators;
import org.moeaframework.core.spi.OperatorProvider;
import org.moeaframework.core.spi.ProviderLookupException;
import org.moeaframework.core.spi.ProviderNotFoundException;
import org.moeaframework.util.TypedProperties;

public class OperatorFactory {
    private static final ServiceLoader<OperatorProvider> PROVIDERS = ServiceLoader.load(OperatorProvider.class);
    private static OperatorFactory instance = new OperatorFactory();
    private List<OperatorProvider> customProviders = new ArrayList<OperatorProvider>();

    public static synchronized OperatorFactory getInstance() {
        return instance;
    }

    public static synchronized void setInstance(OperatorFactory instance) {
        OperatorFactory.instance = instance;
    }

    public void addProvider(OperatorProvider provider) {
        this.customProviders.add(provider);
    }

    public String getDefaultMutation(Problem problem) {
        String result = this.lookupMutationHint(problem);
        if (result == null) {
            throw new ProviderLookupException("unsupported or unknown type");
        }
        return result;
    }

    public String getDefaultVariation(Problem problem) {
        String result = this.lookupVariationHint(problem);
        if (result == null) {
            throw new ProviderLookupException("unsupported or unknown type");
        }
        return result;
    }

    public Variation getVariation(String name, TypedProperties properties, Problem problem) {
        return this.getVariation(name, properties.getProperties(), problem);
    }

    public Variation getVariation(String name, Properties properties, Problem problem) {
        if (name == null) {
            String operator = properties.getProperty("operator", null);
            if (operator == null) {
                String hint = this.lookupVariationHint(problem);
                return this.getVariation(hint, properties, problem);
            }
            return this.getVariation(operator, properties, problem);
        }
        if (name.contains("+")) {
            String[] entries = name.split("\\s*\\+\\s*");
            CompoundVariation variation = new CompoundVariation();
            for (String entry : entries) {
                variation.appendOperator(this.getVariation(entry, properties, problem));
            }
            return variation;
        }
        return this.instantiateVariation(name, properties, problem);
    }

    private Variation instantiateVariation(OperatorProvider provider, String name, Properties properties, Problem problem) {
        try {
            return provider.getVariation(name, properties, problem);
        }
        catch (ServiceConfigurationError e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    private Variation instantiateVariation(String name, Properties properties, Problem problem) {
        Variation variation;
        Variation variation2;
        boolean hasStandardOperators = false;
        for (OperatorProvider provider : this.customProviders) {
            variation2 = this.instantiateVariation(provider, name, properties, problem);
            if (provider.getClass() == StandardOperators.class) {
                hasStandardOperators = true;
            }
            if (variation2 == null) continue;
            return variation2;
        }
        for (OperatorProvider provider : PROVIDERS) {
            variation2 = this.instantiateVariation(provider, name, properties, problem);
            if (provider.getClass() == StandardOperators.class) {
                hasStandardOperators = true;
            }
            if (variation2 == null) continue;
            return variation2;
        }
        if (!hasStandardOperators && (variation = this.instantiateVariation(new StandardOperators(), name, properties, problem)) != null) {
            return variation;
        }
        throw new ProviderNotFoundException(name);
    }

    private String lookupMutationHint(Problem problem) {
        String hint;
        String hint2;
        boolean hasStandardOperators = false;
        for (OperatorProvider provider : this.customProviders) {
            hint2 = provider.getMutationHint(problem);
            if (provider.getClass() == StandardOperators.class) {
                hasStandardOperators = true;
            }
            if (hint2 == null) continue;
            return hint2;
        }
        for (OperatorProvider provider : PROVIDERS) {
            hint2 = provider.getMutationHint(problem);
            if (provider.getClass() == StandardOperators.class) {
                hasStandardOperators = true;
            }
            if (hint2 == null) continue;
            return hint2;
        }
        if (!hasStandardOperators && (hint = new StandardOperators().getMutationHint(problem)) != null) {
            return hint;
        }
        throw new ProviderLookupException("unable to find suitable variation operator");
    }

    private String lookupVariationHint(Problem problem) {
        String hint;
        String hint2;
        boolean hasStandardOperators = false;
        for (OperatorProvider provider : this.customProviders) {
            hint2 = provider.getVariationHint(problem);
            if (provider.getClass() == StandardOperators.class) {
                hasStandardOperators = true;
            }
            if (hint2 == null) continue;
            return hint2;
        }
        for (OperatorProvider provider : PROVIDERS) {
            hint2 = provider.getVariationHint(problem);
            if (provider.getClass() == StandardOperators.class) {
                hasStandardOperators = true;
            }
            if (hint2 == null) continue;
            return hint2;
        }
        if (!hasStandardOperators && (hint = new StandardOperators().getVariationHint(problem)) != null) {
            return hint;
        }
        throw new ProviderLookupException("unable to find suitable variation operator");
    }
}

