/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.ProblemProvider;
import org.moeaframework.core.spi.ProviderNotFoundException;
import org.moeaframework.problem.ClassLoaderProblems;
import org.moeaframework.problem.PropertiesProblems;
import org.moeaframework.problem.RotatedProblems;
import org.moeaframework.problem.StandardProblems;

public class ProblemFactory {
    private static final ServiceLoader<ProblemProvider> PROVIDERS = ServiceLoader.load(ProblemProvider.class);
    private static ProblemFactory instance = new ProblemFactory();
    private List<ProblemProvider> customProviders = new ArrayList<ProblemProvider>();

    public static synchronized ProblemFactory getInstance() {
        return instance;
    }

    public static synchronized void setInstance(ProblemFactory instance) {
        ProblemFactory.instance = instance;
    }

    public void addProvider(ProblemProvider provider) {
        this.customProviders.add(provider);
    }

    public synchronized Problem getProblem(String name) {
        Problem problem;
        for (ProblemProvider provider : this.customProviders) {
            Problem problem2 = this.instantiateProblem(provider, name);
            if (problem2 == null) continue;
            return problem2;
        }
        Iterator<ProblemProvider> iterator = PROVIDERS.iterator();
        while (iterator.hasNext()) {
            problem = this.instantiateProblem(iterator.next(), name);
            if (problem == null) continue;
            return problem;
        }
        problem = this.instantiateProblem(new StandardProblems(), name);
        if (problem == null) {
            problem = this.instantiateProblem(new PropertiesProblems(), name);
        }
        if (problem == null) {
            problem = this.instantiateProblem(new ClassLoaderProblems(), name);
        }
        if (problem == null) {
            problem = this.instantiateProblem(new RotatedProblems(), name);
        }
        if (problem != null) {
            return problem;
        }
        throw new ProviderNotFoundException(name);
    }

    private Problem instantiateProblem(ProblemProvider provider, String name) {
        try {
            return provider.getProblem(name);
        }
        catch (ServiceConfigurationError e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public synchronized NondominatedPopulation getReferenceSet(String name) {
        NondominatedPopulation referenceSet;
        for (ProblemProvider provider : this.customProviders) {
            referenceSet = provider.getReferenceSet(name);
            if (referenceSet == null) continue;
            return referenceSet;
        }
        for (ProblemProvider provider : PROVIDERS) {
            referenceSet = provider.getReferenceSet(name);
            if (referenceSet == null) continue;
            return referenceSet;
        }
        NondominatedPopulation referenceSet2 = new StandardProblems().getReferenceSet(name);
        if (referenceSet2 == null) {
            referenceSet2 = new PropertiesProblems().getReferenceSet(name);
        }
        if (referenceSet2 == null) {
            referenceSet2 = new ClassLoaderProblems().getReferenceSet(name);
        }
        if (referenceSet2 == null) {
            referenceSet2 = new RotatedProblems().getReferenceSet(name);
        }
        if (referenceSet2 != null) {
            return referenceSet2;
        }
        return null;
    }
}

