/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.termination;

import org.moeaframework.core.Algorithm;
import org.moeaframework.core.TerminationCondition;

public class MaxElapsedTime
implements TerminationCondition {
    private final long maxTime;
    private long startTime;

    public MaxElapsedTime(long maxTime) {
        this.maxTime = maxTime;
    }

    @Override
    public void initialize(Algorithm algorithm) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public boolean shouldTerminate(Algorithm algorithm) {
        return System.currentTimeMillis() - this.startTime >= this.maxTime;
    }
}

