/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.variable;

import java.text.MessageFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.variable.BinaryVariable;
import org.moeaframework.core.variable.EncodingUtils;

public class BinaryIntegerVariable
extends BinaryVariable {
    private static final long serialVersionUID = 5045946885389529638L;
    private static final String VALUE_OUT_OF_BOUNDS = "value out of bounds (value: {0}, min: {1}, max: {2})";
    private final int lowerBound;
    private final int upperBound;
    private final boolean gray;

    public BinaryIntegerVariable(int lowerBound, int upperBound) {
        this(lowerBound, upperBound, true);
    }

    public BinaryIntegerVariable(int value, int lowerBound, int upperBound) {
        this(value, lowerBound, upperBound, true);
    }

    public BinaryIntegerVariable(int lowerBound, int upperBound, boolean gray) {
        super(BinaryIntegerVariable.getNumberOfBits(lowerBound, upperBound));
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.gray = gray;
    }

    public BinaryIntegerVariable(int value, int lowerBound, int upperBound, boolean gray) {
        this(lowerBound, upperBound, gray);
        this.setValue(value);
    }

    public static final int getNumberOfBits(int lowerBound, int upperBound) {
        return 32 - Integer.numberOfLeadingZeros(upperBound - lowerBound);
    }

    public int getValue() {
        if (this.gray) {
            EncodingUtils.grayToBinary(this);
        }
        int value = (int)EncodingUtils.decode(this);
        if (this.gray) {
            EncodingUtils.binaryToGray(this);
        }
        if (value > this.upperBound - this.lowerBound) {
            value -= this.upperBound - this.lowerBound;
        }
        return this.lowerBound + value;
    }

    public void setValue(int value) {
        if (value < this.lowerBound || value > this.upperBound) {
            throw new IllegalArgumentException(MessageFormat.format(VALUE_OUT_OF_BOUNDS, value, this.lowerBound, this.upperBound));
        }
        EncodingUtils.encode(value - this.lowerBound, (BinaryVariable)this);
        if (this.gray) {
            EncodingUtils.binaryToGray(this);
        }
    }

    protected boolean isGray() {
        return this.gray;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    @Override
    public BinaryIntegerVariable copy() {
        BinaryIntegerVariable result = new BinaryIntegerVariable(this.getValue(), this.lowerBound, this.upperBound);
        for (int i = 0; i < result.getNumberOfBits(); ++i) {
            result.set(i, this.get(i));
        }
        return result;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.lowerBound).append(this.upperBound).append(this.getValue()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BinaryIntegerVariable rhs = (BinaryIntegerVariable)obj;
        return new EqualsBuilder().append(this.lowerBound, rhs.lowerBound).append(this.upperBound, rhs.upperBound).append(this.getValue(), rhs.getValue()).isEquals();
    }

    @Override
    public String toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public void randomize() {
        this.setValue(PRNG.nextInt(this.lowerBound, this.upperBound));
    }
}

