/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.variable;

import java.util.BitSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Variable;

public class BinaryVariable
implements Variable {
    private static final long serialVersionUID = -682157453241538355L;
    private final int numberOfBits;
    private final BitSet bitSet;

    public BinaryVariable(int numberOfBits) {
        this.numberOfBits = numberOfBits;
        this.bitSet = new BitSet(numberOfBits);
    }

    public int getNumberOfBits() {
        return this.numberOfBits;
    }

    public int cardinality() {
        return this.bitSet.cardinality();
    }

    public void clear() {
        this.bitSet.clear();
    }

    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.numberOfBits) {
            throw new IndexOutOfBoundsException();
        }
        return this.bitSet.get(index);
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.numberOfBits) {
            throw new IndexOutOfBoundsException();
        }
        this.bitSet.set(index, value);
    }

    public BitSet getBitSet() {
        return (BitSet)this.bitSet.clone();
    }

    public int hammingDistance(BinaryVariable variable) {
        if (this.numberOfBits != variable.numberOfBits) {
            throw new IllegalArgumentException("must have same number of bits");
        }
        int count = 0;
        for (int i = 0; i < this.numberOfBits; ++i) {
            if (this.bitSet.get(i) == variable.bitSet.get(i)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public BinaryVariable copy() {
        BinaryVariable copy = new BinaryVariable(this.numberOfBits);
        copy.bitSet.or(this.bitSet);
        return copy;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.numberOfBits).append((Object)this.bitSet).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BinaryVariable rhs = (BinaryVariable)obj;
        return new EqualsBuilder().append(this.numberOfBits, rhs.numberOfBits).append((Object)this.bitSet, (Object)rhs.bitSet).isEquals();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numberOfBits; ++i) {
            sb.append(this.bitSet.get(i) ? "1" : "0");
        }
        return sb.toString();
    }

    @Override
    public void randomize() {
        for (int i = 0; i < this.getNumberOfBits(); ++i) {
            this.set(i, PRNG.nextBoolean());
        }
    }
}

