/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.variable;

import java.util.BitSet;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.variable.BinaryIntegerVariable;
import org.moeaframework.core.variable.BinaryVariable;
import org.moeaframework.core.variable.Permutation;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.core.variable.Subset;

public class EncodingUtils {
    private static final String INVALID_LENGTH = "invalid number of values";
    private static final String INVALID_BITS = "invalid number of bits";
    private static final String NOT_REAL = "not a real variable";
    private static final String NOT_INT = "not an integer variable";
    private static final String NOT_PERMUTATION = "not a permutation";
    private static final String NOT_SUBSET = "not a subset";
    private static final String NOT_BINARY = "not a binary variable";
    private static final String NOT_BOOLEAN = "not a boolean variable";

    private EncodingUtils() {
    }

    public static void encode(RealVariable real, BinaryVariable binary) {
        int numberOfBits = binary.getNumberOfBits();
        double lowerBound = real.getLowerBound();
        double upperBound = real.getUpperBound();
        double value = real.getValue();
        double scale = (value - lowerBound) / (upperBound - lowerBound);
        long index = Math.round(scale * (double)((1L << numberOfBits) - 1L));
        EncodingUtils.encode(index, binary);
    }

    public static void decode(BinaryVariable binary, RealVariable real) {
        int numberOfBits = binary.getNumberOfBits();
        double lowerBound = real.getLowerBound();
        double upperBound = real.getUpperBound();
        long index = EncodingUtils.decode(binary);
        double scale = (double)index / (double)((1L << numberOfBits) - 1L);
        double value = lowerBound + (upperBound - lowerBound) * scale;
        real.setValue(value);
    }

    public static void encode(long value, BinaryVariable binary) {
        int numberOfBits = binary.getNumberOfBits();
        if (value < 0L) {
            throw new IllegalArgumentException("negative value");
        }
        if (numberOfBits < 1 || numberOfBits > 63) {
            throw new IllegalArgumentException(INVALID_BITS);
        }
        if (1L << numberOfBits <= value) {
            throw new IllegalArgumentException("number of bits not sufficient to represent value");
        }
        for (int i = 0; i < numberOfBits; ++i) {
            binary.set(i, (value & 1L << i) != 0L);
        }
    }

    public static long decode(BinaryVariable binary) {
        int numberOfBits = binary.getNumberOfBits();
        if (numberOfBits < 1 || numberOfBits > 63) {
            throw new IllegalArgumentException(INVALID_BITS);
        }
        long value = 0L;
        for (int i = 0; i < numberOfBits; ++i) {
            if (!binary.get(i)) continue;
            value |= 1L << i;
        }
        return value;
    }

    public static void binaryToGray(BinaryVariable variable) {
        int n = variable.getNumberOfBits();
        BitSet binary = variable.getBitSet();
        variable.set(n - 1, binary.get(n - 1));
        for (int i = n - 2; i >= 0; --i) {
            variable.set(i, binary.get(i + 1) ^ binary.get(i));
        }
    }

    public static void grayToBinary(BinaryVariable variable) {
        int n = variable.getNumberOfBits();
        BitSet gray = variable.getBitSet();
        variable.set(n - 1, gray.get(n - 1));
        for (int i = n - 2; i >= 0; --i) {
            variable.set(i, variable.get(i + 1) ^ gray.get(i));
        }
    }

    public static RealVariable newReal(double lowerBound, double upperBound) {
        return new RealVariable(lowerBound, upperBound);
    }

    public static RealVariable newInt(int lowerBound, int upperBound) {
        return new RealVariable(lowerBound, Math.nextAfter((double)(upperBound + 1), Double.NEGATIVE_INFINITY));
    }

    public static BinaryIntegerVariable newBinaryInt(int lowerBound, int upperBound) {
        return new BinaryIntegerVariable(lowerBound, upperBound);
    }

    public static BinaryVariable newBoolean() {
        return new BinaryVariable(1);
    }

    public static BinaryVariable newBinary(int length) {
        return new BinaryVariable(length);
    }

    public static Permutation newPermutation(int length) {
        return new Permutation(length);
    }

    public static Subset newSubset(int k, int n) {
        return new Subset(k, n);
    }

    public static double getReal(Variable variable) {
        if (variable instanceof RealVariable) {
            return ((RealVariable)variable).getValue();
        }
        throw new IllegalArgumentException(NOT_REAL);
    }

    public static int getInt(Variable variable) {
        if (variable instanceof RealVariable) {
            return (int)Math.floor(((RealVariable)variable).getValue());
        }
        if (variable instanceof BinaryIntegerVariable) {
            return (int)Math.floor(((BinaryIntegerVariable)variable).getValue());
        }
        throw new IllegalArgumentException(NOT_INT);
    }

    public static BitSet getBitSet(Variable variable) {
        if (variable instanceof BinaryVariable) {
            return ((BinaryVariable)variable).getBitSet();
        }
        throw new IllegalArgumentException(NOT_BINARY);
    }

    public static boolean[] getBinary(Variable variable) {
        if (variable instanceof BinaryVariable) {
            BinaryVariable binaryVariable = (BinaryVariable)variable;
            boolean[] result = new boolean[binaryVariable.getNumberOfBits()];
            for (int i = 0; i < binaryVariable.getNumberOfBits(); ++i) {
                result[i] = binaryVariable.get(i);
            }
            return result;
        }
        throw new IllegalArgumentException(NOT_BINARY);
    }

    public static boolean getBoolean(Variable variable) {
        boolean[] values = EncodingUtils.getBinary(variable);
        if (values.length == 1) {
            return values[0];
        }
        throw new IllegalArgumentException(NOT_BOOLEAN);
    }

    public static int[] getPermutation(Variable variable) {
        if (variable instanceof Permutation) {
            return ((Permutation)variable).toArray();
        }
        throw new IllegalArgumentException(NOT_PERMUTATION);
    }

    public static int[] getSubset(Variable variable) {
        if (variable instanceof Subset) {
            return ((Subset)variable).toArray();
        }
        throw new IllegalArgumentException(NOT_SUBSET);
    }

    public static double[] getReal(Solution solution) {
        return EncodingUtils.getReal(solution, 0, solution.getNumberOfVariables());
    }

    public static double[] getReal(Solution solution, int startIndex, int endIndex) {
        double[] result = new double[endIndex - startIndex];
        for (int i = startIndex; i < endIndex; ++i) {
            result[i - startIndex] = EncodingUtils.getReal(solution.getVariable(i));
        }
        return result;
    }

    public static int[] getInt(Solution solution) {
        return EncodingUtils.getInt(solution, 0, solution.getNumberOfVariables());
    }

    public static int[] getInt(Solution solution, int startIndex, int endIndex) {
        int[] result = new int[endIndex - startIndex];
        for (int i = startIndex; i < endIndex; ++i) {
            result[i - startIndex] = EncodingUtils.getInt(solution.getVariable(i));
        }
        return result;
    }

    public static void setReal(Variable variable, double value) {
        if (!(variable instanceof RealVariable)) {
            throw new IllegalArgumentException(NOT_REAL);
        }
        ((RealVariable)variable).setValue(value);
    }

    public static void setReal(Solution solution, double[] values) {
        EncodingUtils.setReal(solution, 0, solution.getNumberOfVariables(), values);
    }

    public static void setReal(Solution solution, int startIndex, int endIndex, double[] values) {
        if (values.length != endIndex - startIndex) {
            throw new IllegalArgumentException(INVALID_LENGTH);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            EncodingUtils.setReal(solution.getVariable(i), values[i - startIndex]);
        }
    }

    public static void setInt(Variable variable, int value) {
        if (variable instanceof RealVariable) {
            ((RealVariable)variable).setValue(value);
        } else if (variable instanceof BinaryIntegerVariable) {
            ((BinaryIntegerVariable)variable).setValue(value);
        } else {
            throw new IllegalArgumentException(NOT_INT);
        }
    }

    public static void setInt(Solution solution, int[] values) {
        EncodingUtils.setInt(solution, 0, solution.getNumberOfVariables(), values);
    }

    public static void setInt(Solution solution, int startIndex, int endIndex, int[] values) {
        if (values.length != endIndex - startIndex) {
            throw new IllegalArgumentException(INVALID_LENGTH);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            EncodingUtils.setInt(solution.getVariable(i), values[i - startIndex]);
        }
    }

    public static void setBitSet(Variable variable, BitSet bitSet) {
        if (variable instanceof BinaryVariable) {
            BinaryVariable binaryVariable = (BinaryVariable)variable;
            for (int i = 0; i < binaryVariable.getNumberOfBits(); ++i) {
                binaryVariable.set(i, bitSet.get(i));
            }
        } else {
            throw new IllegalArgumentException(NOT_BINARY);
        }
    }

    public static void setBinary(Variable variable, boolean[] values) {
        if (variable instanceof BinaryVariable) {
            BinaryVariable binaryVariable = (BinaryVariable)variable;
            if (values.length != binaryVariable.getNumberOfBits()) {
                throw new IllegalArgumentException(INVALID_LENGTH);
            }
            for (int i = 0; i < binaryVariable.getNumberOfBits(); ++i) {
                binaryVariable.set(i, values[i]);
            }
        } else {
            throw new IllegalArgumentException(NOT_BINARY);
        }
    }

    public static void setBoolean(Variable variable, boolean value) {
        EncodingUtils.setBinary(variable, new boolean[]{value});
    }

    public static void setPermutation(Variable variable, int[] values) {
        if (!(variable instanceof Permutation)) {
            throw new IllegalArgumentException(NOT_PERMUTATION);
        }
        ((Permutation)variable).fromArray(values);
    }

    public static void setSubset(Variable variable, int[] values) {
        if (!(variable instanceof Subset)) {
            throw new IllegalArgumentException(NOT_SUBSET);
        }
        ((Subset)variable).fromArray(values);
    }
}

