/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.variable;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Variable;

public class Grammar
implements Variable {
    private static final long serialVersionUID = 1701058698946283174L;
    private int[] codon;
    private int maximumValue = 256;

    public Grammar(int size) {
        this(new int[size]);
    }

    public Grammar(int[] codon) {
        this.fromArray(codon);
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(int maximumValue) {
        this.maximumValue = maximumValue;
    }

    public int[] toArray() {
        return (int[])this.codon.clone();
    }

    public void fromArray(int[] codon) {
        for (int i = 0; i < codon.length; ++i) {
            if (codon[i] >= 0 && codon[i] < this.maximumValue) continue;
            throw new IllegalArgumentException("invalid codon value");
        }
        this.codon = (int[])codon.clone();
    }

    public int size() {
        return this.codon.length;
    }

    public void set(int index, int value) {
        if (value < 0 || value >= this.maximumValue) {
            throw new IllegalArgumentException("invalid codon value");
        }
        this.codon[index] = value;
    }

    public int get(int index) {
        return this.codon[index];
    }

    @Override
    public Grammar copy() {
        return new Grammar(this.codon);
    }

    public int[] cut(int start, int end) {
        int i;
        if (start > end) {
            throw new IllegalArgumentException("start not before end");
        }
        int[] newCodon = new int[this.codon.length - (end - start + 1)];
        int[] result = new int[end - start + 1];
        int index = 0;
        for (i = 0; i < start; ++i) {
            newCodon[index++] = this.codon[i];
        }
        for (i = start; i <= end; ++i) {
            result[i - start] = this.codon[i];
        }
        for (i = end + 1; i < this.codon.length; ++i) {
            newCodon[index++] = this.codon[i];
        }
        this.fromArray(newCodon);
        return result;
    }

    public void insert(int insertIndex, int[] array) {
        int i;
        int[] newCodon = new int[this.codon.length + array.length];
        int index = 0;
        for (i = 0; i < insertIndex; ++i) {
            newCodon[index++] = this.codon[i];
        }
        for (i = 0; i < array.length; ++i) {
            newCodon[index++] = array[i];
        }
        for (i = insertIndex; i < this.codon.length; ++i) {
            newCodon[index++] = this.codon[i];
        }
        this.fromArray(newCodon);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.codon).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Grammar rhs = (Grammar)obj;
        return new EqualsBuilder().append(this.codon, rhs.codon).isEquals();
    }

    @Override
    public void randomize() {
        for (int i = 0; i < this.codon.length; ++i) {
            this.codon[i] = PRNG.nextInt(this.getMaximumValue());
        }
    }
}

