/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.variable;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Variable;

public class Permutation
implements Variable {
    private static final long serialVersionUID = 5690584295426235286L;
    private int[] permutation;

    public Permutation(int size) {
        this.permutation = new int[size];
        for (int i = 0; i < size; ++i) {
            this.permutation[i] = i;
        }
    }

    public Permutation(int[] permutation) {
        this.permutation = permutation;
        this.fromArray(permutation);
    }

    @Override
    public Permutation copy() {
        return new Permutation(this.permutation);
    }

    public int size() {
        return this.permutation.length;
    }

    public int get(int index) {
        return this.permutation[index];
    }

    public void swap(int i, int j) {
        int temp = this.permutation[i];
        this.permutation[i] = this.permutation[j];
        this.permutation[j] = temp;
    }

    public void insert(int i, int j) {
        int temp = this.permutation[i];
        if (i < j) {
            for (int k = i + 1; k <= j; ++k) {
                this.permutation[k - 1] = this.permutation[k];
            }
        } else if (i > j) {
            for (int k = i - 1; k >= j; --k) {
                this.permutation[k + 1] = this.permutation[k];
            }
        }
        this.permutation[j] = temp;
    }

    public int[] toArray() {
        return (int[])this.permutation.clone();
    }

    public void fromArray(int[] permutation) {
        if (!Permutation.isPermutation(permutation)) {
            throw new IllegalArgumentException("invalid permutation");
        }
        if (this.permutation.length != permutation.length) {
            throw new IllegalArgumentException("invalid permutation length");
        }
        this.permutation = (int[])permutation.clone();
    }

    public static boolean isPermutation(int[] permutation) {
        for (int i = 0; i < permutation.length; ++i) {
            boolean contains = false;
            for (int j = 0; j < permutation.length; ++j) {
                if (permutation[j] != i) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.permutation).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Permutation rhs = (Permutation)obj;
        return new EqualsBuilder().append(this.permutation, rhs.permutation).isEquals();
    }

    @Override
    public void randomize() {
        PRNG.shuffle(this.permutation);
    }
}

