/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.variable;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Variable;

public class Subset
implements Variable {
    private static final long serialVersionUID = -4491760813656852414L;
    private static final double OPT_FACTOR = 1.1;
    private static final boolean VALIDATE = false;
    private int n;
    private int[] members;
    private Set<Integer> memberSet;

    public Subset(int k, int n) {
        this.n = n;
        if (k > n) {
            throw new IllegalArgumentException("k must be <= n");
        }
        this.members = new int[k];
        this.memberSet = new HashSet<Integer>();
        for (int i = 0; i < k; ++i) {
            this.members[i] = i;
            this.memberSet.add(i);
        }
    }

    public int getK() {
        return this.members.length;
    }

    public int getN() {
        return this.n;
    }

    public int get(int index) {
        return this.members[index];
    }

    public void validate() {
    }

    public void set(int index, int value) {
        this.memberSet.remove(this.members[index]);
        this.members[index] = value;
        this.memberSet.add(value);
        this.validate();
    }

    public Set<Integer> getSet() {
        return Collections.unmodifiableSet(this.memberSet);
    }

    public int[] toArray() {
        return (int[])this.members.clone();
    }

    public void fromArray(int[] members) {
        if (this.members.length != members.length) {
            throw new IllegalArgumentException("invalid subset length");
        }
        this.memberSet.clear();
        for (int i = 0; i < members.length; ++i) {
            this.members[i] = members[i];
            this.memberSet.add(members[i]);
        }
        this.validate();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.n).append(this.members).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Subset rhs = (Subset)obj;
        return new EqualsBuilder().append(this.n, rhs.n).append(this.members, rhs.members).isEquals();
    }

    @Override
    public Subset copy() {
        Subset copy = new Subset(this.members.length, this.n);
        copy.fromArray(this.members);
        return copy;
    }

    @Override
    public void randomize() {
        if ((double)this.members.length < (double)this.n / 1.1) {
            HashSet<Integer> generated = new HashSet<Integer>();
            for (int i = 0; i < this.members.length; ++i) {
                int value;
                while (generated.contains(value = PRNG.nextInt(this.n))) {
                }
                this.members[i] = value;
                generated.add(value);
            }
        } else {
            int i;
            LinkedList<Integer> pool = new LinkedList<Integer>();
            for (i = 0; i < this.n; ++i) {
                pool.add(i);
            }
            for (i = 0; i < this.members.length; ++i) {
                this.members[i] = (Integer)pool.remove(PRNG.nextInt(pool.size()));
            }
        }
    }

    public int randomNonmember() {
        if (this.members.length == this.n) {
            throw new FrameworkException("no non-member exists (k == n)");
        }
        if ((double)this.members.length < (double)this.n / 1.1) {
            int value;
            while (this.memberSet.contains(value = PRNG.nextInt(this.n))) {
            }
            return value;
        }
        int result = -1;
        int count = 0;
        for (int i = 0; i < this.n; ++i) {
            if (this.memberSet.contains(i) || PRNG.nextInt(++count) != 0) continue;
            result = i;
        }
        return result;
    }
}

