/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem;

import org.moeaframework.core.Problem;

public abstract class AbstractProblem
implements Problem {
    protected final int numberOfVariables;
    protected final int numberOfObjectives;
    protected final int numberOfConstraints;
    private boolean isClosed;

    public AbstractProblem(int numberOfVariables, int numberOfObjectives) {
        this(numberOfVariables, numberOfObjectives, 0);
    }

    public AbstractProblem(int numberOfVariables, int numberOfObjectives, int numberOfConstraints) {
        this.numberOfVariables = numberOfVariables;
        this.numberOfObjectives = numberOfObjectives;
        this.numberOfConstraints = numberOfConstraints;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getNumberOfVariables() {
        return this.numberOfVariables;
    }

    @Override
    public int getNumberOfObjectives() {
        return this.numberOfObjectives;
    }

    @Override
    public int getNumberOfConstraints() {
        return this.numberOfConstraints;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            this.close();
        }
        super.finalize();
    }

    @Override
    public void close() {
        this.isClosed = true;
    }
}

