/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.ProblemProvider;
import org.moeaframework.problem.BBOB2016.AttractiveSector;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBUtils;
import org.moeaframework.problem.BBOB2016.DifferentPowers;
import org.moeaframework.problem.BBOB2016.Ellipsoid;
import org.moeaframework.problem.BBOB2016.Gallagher;
import org.moeaframework.problem.BBOB2016.Rastrigin;
import org.moeaframework.problem.BBOB2016.Rosenbrock;
import org.moeaframework.problem.BBOB2016.Schaffers;
import org.moeaframework.problem.BBOB2016.Schwefel;
import org.moeaframework.problem.BBOB2016.SharpRidge;
import org.moeaframework.problem.BBOB2016.Sphere;
import org.moeaframework.problem.BBOB2016.StackedProblem;
import org.moeaframework.problem.BBOB2016.TransformObjectiveOscillate;
import org.moeaframework.problem.BBOB2016.TransformObjectivePenalize;
import org.moeaframework.problem.BBOB2016.TransformObjectivePower;
import org.moeaframework.problem.BBOB2016.TransformObjectiveShift;
import org.moeaframework.problem.BBOB2016.TransformVariablesAffine;
import org.moeaframework.problem.BBOB2016.TransformVariablesAsymmetric;
import org.moeaframework.problem.BBOB2016.TransformVariablesOscillate;
import org.moeaframework.problem.BBOB2016.TransformVariablesScale;
import org.moeaframework.problem.BBOB2016.TransformVariablesShift;
import org.moeaframework.problem.BBOB2016.TransformVariablesXHat;
import org.moeaframework.problem.BBOB2016.TransformVariablesZHat;

public class BBOB2016Problems
extends ProblemProvider {
    @Override
    public Problem getProblem(String name) {
        Pattern pattern = Pattern.compile("^bbob_f([0-9]+)_i([0-9]+)_d([0-9]+)__bbob_f([0-9]+)_i([0-9]+)_d([0-9]+)$");
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            return new StackedProblem(BBOB2016Problems.createInstance(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(2))), BBOB2016Problems.createInstance(Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(6)), Integer.parseInt(matcher.group(5))));
        }
        return null;
    }

    @Override
    public NondominatedPopulation getReferenceSet(String name) {
        return null;
    }

    public static BBOBFunction createInstance(int function, int dimension, int instance) {
        int rseed = function + 10000 * instance;
        if (function == 1) {
            double[] xopt = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            BBOBFunction problem = new Sphere(dimension);
            problem = new TransformVariablesShift(problem, xopt);
            problem = new TransformObjectiveShift(problem, fopt);
            return problem;
        }
        if (function == 2) {
            double[] xopt = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            BBOBFunction problem = new Ellipsoid(dimension);
            problem = new TransformVariablesOscillate(problem);
            problem = new TransformVariablesShift(problem, xopt);
            problem = new TransformObjectiveShift(problem, fopt);
            return problem;
        }
        if (function == 6) {
            double[] xopt = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            double[] b = new double[dimension];
            double[][] M = new double[dimension][dimension];
            double[][] rot1 = BBOBUtils.computeRotation(rseed + 1000000, dimension);
            double[][] rot2 = BBOBUtils.computeRotation(rseed, dimension);
            for (int i = 0; i < dimension; ++i) {
                b[i] = 0.0;
                for (int j = 0; j < dimension; ++j) {
                    M[i][j] = 0.0;
                    for (int k = 0; k < dimension; ++k) {
                        double exponent = 1.0 * (double)k / ((double)dimension - 1.0);
                        double[] dArray = M[i];
                        int n = j;
                        dArray[n] = dArray[n] + rot1[i][k] * Math.pow(Math.sqrt(10.0), exponent) * rot2[k][j];
                    }
                }
            }
            BBOBFunction problem = new AttractiveSector(dimension, xopt);
            problem = new TransformObjectiveOscillate(problem);
            problem = new TransformObjectivePower(problem, 0.9);
            problem = new TransformObjectiveShift(problem, fopt);
            problem = new TransformVariablesAffine(problem, M, b);
            problem = new TransformVariablesShift(problem, xopt);
            return problem;
        }
        if (function == 8) {
            double[] xopt = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            double[] minusOne = new double[dimension];
            int i = 0;
            while (i < dimension) {
                minusOne[i] = -1.0;
                int n = i++;
                xopt[n] = xopt[n] * 0.75;
            }
            BBOBFunction problem = new Rosenbrock(dimension);
            problem = new TransformVariablesShift(problem, minusOne);
            problem = new TransformVariablesScale(problem, Math.max(1.0, Math.sqrt((double)dimension / 8.0)));
            problem = new TransformVariablesShift(problem, xopt);
            problem = new TransformObjectiveShift(problem, fopt);
            return problem;
        }
        if (function == 13) {
            double[] xopt = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            double[] b = new double[dimension];
            double[][] M = new double[dimension][dimension];
            double[][] rot1 = BBOBUtils.computeRotation(rseed + 1000000, dimension);
            double[][] rot2 = BBOBUtils.computeRotation(rseed, dimension);
            for (int i = 0; i < dimension; ++i) {
                b[i] = 0.0;
                for (int j = 0; j < dimension; ++j) {
                    M[i][j] = 0.0;
                    for (int k = 0; k < dimension; ++k) {
                        double exponent = 1.0 * (double)k / ((double)dimension - 1.0);
                        double[] dArray = M[i];
                        int n = j;
                        dArray[n] = dArray[n] + rot1[i][k] * Math.pow(Math.sqrt(10.0), exponent) * rot2[k][j];
                    }
                }
            }
            BBOBFunction problem = new SharpRidge(dimension);
            problem = new TransformObjectiveShift(problem, fopt);
            problem = new TransformVariablesAffine(problem, M, b);
            problem = new TransformVariablesShift(problem, xopt);
            return problem;
        }
        if (function == 14) {
            double[] xopt = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            double[] b = new double[dimension];
            double[][] M = BBOBUtils.computeRotation(rseed + 1000000, dimension);
            BBOBFunction problem = new DifferentPowers(dimension);
            problem = new TransformObjectiveShift(problem, fopt);
            problem = new TransformVariablesAffine(problem, M, b);
            problem = new TransformVariablesShift(problem, xopt);
            return problem;
        }
        if (function == 15) {
            double[] xopt = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            double[] zeros = new double[dimension];
            double[] b = new double[dimension];
            double[][] M = new double[dimension][dimension];
            double[][] rot1 = BBOBUtils.computeRotation(rseed + 1000000, dimension);
            double[][] rot2 = BBOBUtils.computeRotation(rseed, dimension);
            for (int i = 0; i < dimension; ++i) {
                b[i] = 0.0;
                for (int j = 0; j < dimension; ++j) {
                    M[i][j] = 0.0;
                    for (int k = 0; k < dimension; ++k) {
                        double exponent = 1.0 * (double)k / ((double)dimension - 1.0);
                        double[] dArray = M[i];
                        int n = j;
                        dArray[n] = dArray[n] + rot1[i][k] * Math.pow(Math.sqrt(10.0), exponent) * rot2[k][j];
                    }
                }
            }
            BBOBFunction problem = new Rastrigin(dimension);
            problem = new TransformObjectiveShift(problem, fopt);
            problem = new TransformVariablesAffine(problem, M, b);
            problem = new TransformVariablesAsymmetric(problem, 0.2);
            problem = new TransformVariablesOscillate(problem);
            problem = new TransformVariablesAffine(problem, rot1, zeros);
            problem = new TransformVariablesShift(problem, xopt);
            return problem;
        }
        if (function == 17) {
            double[] xopt = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            double[] zeros = new double[dimension];
            double[] b = new double[dimension];
            double[][] M = new double[dimension][dimension];
            double[][] rot1 = BBOBUtils.computeRotation(rseed + 1000000, dimension);
            double[][] rot2 = BBOBUtils.computeRotation(rseed, dimension);
            for (int i = 0; i < dimension; ++i) {
                b[i] = 0.0;
                for (int j = 0; j < dimension; ++j) {
                    double exponent = 1.0 * (double)i / ((double)dimension - 1.0);
                    double[] dArray = M[i];
                    int n = j;
                    dArray[n] = dArray[n] + rot2[i][j] * Math.pow(Math.sqrt(10.0), exponent);
                }
            }
            BBOBFunction problem = new Schaffers(dimension);
            problem = new TransformObjectiveShift(problem, fopt);
            problem = new TransformVariablesAffine(problem, M, b);
            problem = new TransformVariablesAsymmetric(problem, 0.5);
            problem = new TransformVariablesAffine(problem, rot1, zeros);
            problem = new TransformVariablesShift(problem, xopt);
            problem = new TransformObjectivePenalize(problem, 10.0);
            return problem;
        }
        if (function == 20) {
            int i;
            double[] tmp1 = BBOBUtils.computeXOpt(rseed, dimension);
            double fopt = BBOBUtils.computeFOpt(function, instance);
            double[] xopt = new double[dimension];
            double[] tmp2 = new double[dimension];
            double[] b = new double[dimension];
            double[][] M = new double[dimension][dimension];
            for (i = 0; i < dimension; ++i) {
                xopt[i] = 2.10484373165;
                if (!(tmp1[i] - 0.5 < 0.0)) continue;
                int n = i;
                xopt[n] = xopt[n] * -1.0;
            }
            for (i = 0; i < dimension; ++i) {
                b[i] = 0.0;
                for (int j = 0; j < dimension; ++j) {
                    if (i != j) continue;
                    double exponent = 1.0 * (double)i / ((double)dimension - 1.0);
                    double[] dArray = M[i];
                    int n = j;
                    dArray[n] = dArray[n] + Math.pow(Math.sqrt(10.0), exponent);
                }
            }
            for (i = 0; i < dimension; ++i) {
                tmp1[i] = -2.0 * Math.abs(xopt[i]);
                tmp2[i] = 2.0 * Math.abs(xopt[i]);
            }
            BBOBFunction problem = new Schwefel(dimension);
            problem = new TransformObjectiveShift(problem, fopt);
            problem = new TransformVariablesScale(problem, 100.0);
            problem = new TransformVariablesShift(problem, tmp1);
            problem = new TransformVariablesAffine(problem, M, b);
            problem = new TransformVariablesShift(problem, tmp2);
            problem = new TransformVariablesZHat(problem, xopt);
            problem = new TransformVariablesScale(problem, 2.0);
            problem = new TransformVariablesXHat(problem, (long)rseed);
            return problem;
        }
        if (function == 21) {
            int j;
            int i;
            int numberOfPeaks = 101;
            double maxcondition = 1000.0;
            double maxcondition1 = Math.sqrt(1000.0);
            double b = 10.0;
            double c = 5.0;
            double[] fitvalues = new double[]{1.1, 9.1};
            double[] xopt = new double[dimension];
            double fopt = BBOBUtils.computeFOpt(function, instance);
            double[][] xLocal = new double[dimension][numberOfPeaks];
            double[][] arrScales = new double[numberOfPeaks][dimension];
            double[][] rotation = BBOBUtils.computeRotation(rseed, dimension);
            double[] gallagher_peaks = BBOBUtils.uniform(numberOfPeaks - 1, rseed);
            ArrayList<Integer> rperm = new ArrayList<Integer>();
            for (int i2 = 0; i2 < numberOfPeaks - 1; ++i2) {
                rperm.add(i2);
            }
            Collections.sort(rperm, new GallagherPeakComprator(gallagher_peaks));
            double[] arrCondition = new double[numberOfPeaks];
            arrCondition[0] = maxcondition1;
            double[] peaks = new double[numberOfPeaks];
            peaks[0] = 10.0;
            for (i = 1; i < numberOfPeaks; ++i) {
                arrCondition[i] = Math.pow(maxcondition, (double)((Integer)rperm.get(i - 1)).intValue() / ((double)numberOfPeaks - 2.0));
                peaks[i] = ((double)i - 1.0) / ((double)numberOfPeaks - 2.0) * (fitvalues[1] - fitvalues[0]) + fitvalues[0];
            }
            for (i = 0; i < numberOfPeaks; ++i) {
                rperm.clear();
                gallagher_peaks = BBOBUtils.uniform(dimension, rseed + 1000 * i);
                for (j = 0; j < dimension; ++j) {
                    rperm.add(j);
                }
                Collections.sort(rperm, new GallagherPeakComprator(gallagher_peaks));
                for (j = 0; j < dimension; ++j) {
                    arrScales[i][j] = Math.pow(arrCondition[i], (double)((Integer)rperm.get(j)).intValue() / ((double)dimension - 1.0) - 0.5);
                }
            }
            gallagher_peaks = BBOBUtils.uniform(dimension * numberOfPeaks, rseed);
            for (i = 0; i < dimension; ++i) {
                xopt[i] = 0.8 * (b * gallagher_peaks[i] - c);
                for (j = 0; j < numberOfPeaks; ++j) {
                    xLocal[i][j] = 0.0;
                    for (int k = 0; k < dimension; ++k) {
                        double[] dArray = xLocal[i];
                        int n = j;
                        dArray[n] = dArray[n] + rotation[i][k] * (b * gallagher_peaks[j * dimension + k] - c);
                    }
                    if (j != 0) continue;
                    double[] dArray = xLocal[i];
                    int n = j;
                    dArray[n] = dArray[n] * 0.8;
                }
            }
            BBOBFunction problem = new Gallagher(dimension, rotation, xLocal, arrScales, peaks);
            problem = new TransformObjectiveShift(problem, fopt);
            return problem;
        }
        throw new FrameworkException("unknown BBOB function " + function);
    }

    private static class GallagherPeakComprator
    implements Comparator<Integer> {
        private final double[] gallagher_peaks;

        public GallagherPeakComprator(double[] gallagher_peaks) {
            this.gallagher_peaks = gallagher_peaks;
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            return Double.compare(this.gallagher_peaks[i1], this.gallagher_peaks[i2]);
        }
    }
}

