/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.variable.RealVariable;

public class BBOBUtils {
    private static double LOWER_BOUND = -100000.0;
    private static double UPPER_BOUND = 100000.0;

    public static void setBounds(double lower, double upper) {
        LOWER_BOUND = lower;
        UPPER_BOUND = upper;
    }

    public static RealVariable createTransformedVariable() {
        return new RealVariable(LOWER_BOUND, UPPER_BOUND);
    }

    public static double[] uniform(int N, long inseed) {
        int tmp;
        int i;
        long[] rgrand = new long[32];
        double[] r = new double[N];
        if (inseed < 0L) {
            inseed = -inseed;
        }
        if (inseed < 1L) {
            inseed = 1L;
        }
        long aktseed = inseed;
        for (i = 39; i >= 0; --i) {
            tmp = (int)Math.floor((double)aktseed / 127773.0);
            if ((aktseed = 16807L * (aktseed - (long)(tmp * 127773)) - (long)(2836 * tmp)) < 0L) {
                aktseed += Integer.MAX_VALUE;
            }
            if (i >= 32) continue;
            rgrand[i] = aktseed;
        }
        long aktrand = rgrand[0];
        for (i = 0; i < N; ++i) {
            tmp = (int)Math.floor((double)aktseed / 127773.0);
            if ((aktseed = 16807L * (aktseed - (long)(tmp * 127773)) - (long)(2836 * tmp)) < 0L) {
                aktseed += Integer.MAX_VALUE;
            }
            tmp = (int)Math.floor((double)aktrand / 6.7108865E7);
            aktrand = rgrand[tmp];
            rgrand[tmp] = aktseed;
            r[i] = (double)aktrand / 2.147483647E9;
            if (r[i] != 0.0) continue;
            r[i] = 1.0E-99;
        }
        return r;
    }

    public static double[] computeXOpt(long seed, int N) {
        double[] xopt = BBOBUtils.uniform(N, seed);
        for (int i = 0; i < N; ++i) {
            xopt[i] = 8.0 * Math.floor(10000.0 * xopt[i]) / 10000.0 - 4.0;
            if (xopt[i] != 0.0) continue;
            xopt[i] = -1.0E-5;
        }
        return xopt;
    }

    public static double computeFOpt(int function, int instance) {
        int rseed = function == 4 ? 3 : (function == 18 ? 17 : (function == 101 || function == 102 || function == 103 || function == 107 || function == 108 || function == 109 ? 1 : (function == 104 || function == 105 || function == 106 || function == 110 || function == 111 || function == 112 ? 8 : (function == 113 || function == 114 || function == 115 ? 7 : (function == 116 || function == 117 || function == 118 ? 10 : (function == 119 || function == 120 || function == 121 ? 14 : (function == 122 || function == 123 || function == 124 ? 17 : (function == 125 || function == 126 || function == 127 ? 19 : (function == 128 || function == 129 || function == 130 ? 21 : function)))))))));
        int rrseed = rseed + 10000 * instance;
        double gval = BBOBUtils.gauss(1, rrseed)[0];
        double gval2 = BBOBUtils.gauss(1, rrseed + 1)[0];
        return BBOBUtils.fmin(1000.0, BBOBUtils.fmax(-1000.0, BBOBUtils.round(10000.0 * gval / gval2) / 100.0));
    }

    public static double fmin(double a, double b) {
        return a < b ? a : b;
    }

    public static double fmax(double a, double b) {
        return a > b ? a : b;
    }

    public static double round(double x) {
        return Math.floor(x + 0.5);
    }

    public static double[] gauss(int N, long seed) {
        double[] uniftmp = BBOBUtils.uniform(2 * N, seed);
        double[] g = new double[N];
        for (int i = 0; i < N; ++i) {
            g[i] = Math.sqrt(-2.0 * Math.log(uniftmp[i])) * Math.cos(Math.PI * 2 * uniftmp[N + i]);
            if (g[i] != 0.0) continue;
            g[i] = 1.0E-99;
        }
        return g;
    }

    public static double[][] reshape(double[] vector, int m, int n) {
        double[][] B = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                B[i][j] = vector[j * m + i];
            }
        }
        return B;
    }

    public static double[][] computeRotation(long seed, int N) {
        double[] gvect = BBOBUtils.gauss(N * N, seed);
        double[][] B = BBOBUtils.reshape(gvect, N, N);
        for (int i = 0; i < N; ++i) {
            int k;
            double prod;
            for (int j = 0; j < i; ++j) {
                int k2;
                prod = 0.0;
                for (k2 = 0; k2 < N; ++k2) {
                    prod += B[k2][i] * B[k2][j];
                }
                for (k2 = 0; k2 < N; ++k2) {
                    double[] dArray = B[k2];
                    int n = i;
                    dArray[n] = dArray[n] - prod * B[k2][j];
                }
            }
            prod = 0.0;
            for (k = 0; k < N; ++k) {
                prod += B[k][i] * B[k][i];
            }
            for (k = 0; k < N; ++k) {
                double[] dArray = B[k];
                int n = i;
                dArray[n] = dArray[n] / Math.sqrt(prod);
            }
        }
        return B;
    }
}

