/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.BBOB2016.BBOBFunction;

public class Gallagher
extends BBOBFunction {
    private final double[][] rotation;
    private final double[][] xLocal;
    private final double[][] arrScales;
    private final double[] peaks;

    public Gallagher(int numberOfVariables, double[][] rotation, double[][] xLocal, double[][] arrScales, double[] peaks) {
        super(numberOfVariables);
        this.rotation = rotation;
        this.xLocal = xLocal;
        this.arrScales = arrScales;
        this.peaks = peaks;
    }

    @Override
    public void evaluate(Solution solution) {
        int i;
        double[] x = EncodingUtils.getReal(solution);
        double[] tmx = new double[x.length];
        double f = 0.0;
        double a = 0.1;
        double penalty = 0.0;
        double ftrue = 0.0;
        double fac = -0.5 / (double)x.length;
        for (i = 0; i < x.length; ++i) {
            double tmp = Math.abs(x[i]) - 5.0;
            if (!(tmp > 0.0)) continue;
            penalty += tmp * tmp;
        }
        for (i = 0; i < x.length; ++i) {
            tmx[i] = 0.0;
            for (int j = 0; j < x.length; ++j) {
                int n = i;
                tmx[n] = tmx[n] + this.rotation[i][j] * x[j];
            }
        }
        for (i = 0; i < this.peaks.length; ++i) {
            double tmp2 = 0.0;
            for (int j = 0; j < x.length; ++j) {
                double tmp1 = tmx[j] - this.xLocal[j][i];
                tmp2 += this.arrScales[i][j] * tmp1 * tmp1;
            }
            tmp2 = this.peaks[i] * Math.exp(fac * tmp2);
            f = Math.max(f, tmp2);
        }
        if ((f = 10.0 - f) > 0.0) {
            ftrue = Math.log(f) / a;
            ftrue = Math.pow(Math.exp(ftrue + 0.49 * (Math.sin(ftrue) + Math.sin(0.79 * ftrue))), a);
        } else if (f < 0.0) {
            ftrue = Math.log(-f) / a;
            ftrue = -Math.pow(Math.exp(ftrue + 0.49 * (Math.sin(0.55 * ftrue) + Math.sin(0.31 * ftrue))), a);
        } else {
            ftrue = f;
        }
        solution.setObjective(0, ftrue * ftrue + penalty);
    }
}

