/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.BBOB2016.BBOBFunction;

public class Schwefel
extends BBOBFunction {
    public Schwefel(int numberOfVariables) {
        super(numberOfVariables);
    }

    @Override
    public void evaluate(Solution solution) {
        int i;
        double[] x = EncodingUtils.getReal(solution);
        double penalty = 0.0;
        double sum = 0.0;
        for (i = 0; i < x.length; ++i) {
            double tmp = Math.abs(x[i]) - 500.0;
            if (!(tmp > 0.0)) continue;
            penalty += tmp * tmp;
        }
        for (i = 0; i < x.length; ++i) {
            sum += x[i] * Math.sin(Math.sqrt(Math.abs(x[i])));
        }
        solution.setObjective(0, 0.01 * (penalty + 418.9828872724339 - sum / (double)x.length));
    }
}

