/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.BBOB2016.BBOBFunction;

public class StackedProblem
extends AbstractProblem {
    private final BBOBFunction[] functions;

    public StackedProblem(BBOBFunction ... functions) {
        super(functions[0].getNumberOfVariables(), functions.length);
        this.functions = functions;
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        for (int i = 0; i < this.functions.length; ++i) {
            Solution instanceSolution = this.functions[i].newSolution();
            EncodingUtils.setReal(instanceSolution, x);
            this.functions[i].evaluate(instanceSolution);
            solution.setObjective(i, instanceSolution.getObjective(0));
        }
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, this.numberOfObjectives);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, EncodingUtils.newReal(-5.0, 5.0));
        }
        return solution;
    }
}

