/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBTransformation;

public class TransformObjectiveOscillate
extends BBOBTransformation {
    public static final double ALPHA = 0.1;

    public TransformObjectiveOscillate(BBOBFunction function) {
        super(function);
    }

    @Override
    public void evaluate(Solution solution) {
        this.function.evaluate(solution);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            double y = solution.getObjective(i);
            if (y != 0.0) {
                double base;
                double tmp = Math.log(Math.abs(y)) / 0.1;
                if (y > 0.0) {
                    base = Math.exp(tmp + 0.49 * (Math.sin(tmp) + Math.sin(0.79 * tmp)));
                    y = Math.pow(base, 0.1);
                } else if (y < 0.0) {
                    base = Math.exp(tmp + 0.49 * (Math.sin(0.55 * tmp) + Math.sin(0.31 * tmp)));
                    y = -Math.pow(base, 0.1);
                }
            }
            solution.setObjective(i, y);
        }
    }
}

