/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBTransformation;

public class TransformObjectivePenalize
extends BBOBTransformation {
    private final double factor;

    public TransformObjectivePenalize(BBOBFunction function, double factor) {
        super(function);
        this.factor = factor;
    }

    @Override
    public void evaluate(Solution solution) {
        int i;
        double penalty = 0.0;
        double lowerBound = -5.0;
        double upperBound = 5.0;
        for (i = 0; i < this.numberOfVariables; ++i) {
            RealVariable v = (RealVariable)solution.getVariable(i);
            double c1 = v.getValue() - upperBound;
            double c2 = lowerBound - v.getValue();
            if (c1 > 0.0) {
                penalty += c1 * c1;
                continue;
            }
            if (!(c2 > 0.0)) continue;
            penalty += c2 * c2;
        }
        this.function.evaluate(solution);
        for (i = 0; i < this.numberOfObjectives; ++i) {
            solution.setObjective(i, solution.getObjective(i) + this.factor * penalty);
        }
    }
}

