/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBTransformation;

public class TransformVariablesAffine
extends BBOBTransformation {
    private final double[][] M;
    private final double[] b;

    public TransformVariablesAffine(BBOBFunction function, double[][] M, double[] b) {
        super(function);
        this.M = M;
        this.b = b;
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double[] tx = (double[])x.clone();
        for (int i = 0; i < x.length; ++i) {
            tx[i] = this.b[i];
            for (int j = 0; j < x.length; ++j) {
                int n = i;
                tx[n] = tx[n] + x[j] * this.M[i][j];
            }
        }
        EncodingUtils.setReal(solution, tx);
        this.function.evaluate(solution);
        EncodingUtils.setReal(solution, x);
    }
}

