/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBTransformation;

public class TransformVariablesAsymmetric
extends BBOBTransformation {
    private final double beta;

    public TransformVariablesAsymmetric(BBOBFunction function, double beta) {
        super(function);
        this.beta = beta;
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double[] tx = (double[])x.clone();
        for (int i = 0; i < x.length; ++i) {
            if (x[i] > 0.0) {
                double exponent = 1.0 + this.beta * (double)i / ((double)x.length - 1.0) * Math.sqrt(x[i]);
                tx[i] = Math.pow(x[i], exponent);
                continue;
            }
            tx[i] = x[i];
        }
        EncodingUtils.setReal(solution, tx);
        this.function.evaluate(solution);
        EncodingUtils.setReal(solution, x);
    }
}

