/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBTransformation;

public class TransformVariablesConditioning
extends BBOBTransformation {
    private final double alpha;

    public TransformVariablesConditioning(BBOBFunction function, double alpha) {
        super(function);
        this.alpha = alpha;
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double[] tx = (double[])x.clone();
        for (int i = 0; i < x.length; ++i) {
            tx[i] = Math.pow(this.alpha, 0.5 * (double)i / ((double)x.length - 1.0)) * x[i];
        }
        EncodingUtils.setReal(solution, tx);
        this.function.evaluate(solution);
        EncodingUtils.setReal(solution, x);
    }
}

