/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBTransformation;

public class TransformVariablesOscillate
extends BBOBTransformation {
    public static final double ALPHA = 0.1;

    public TransformVariablesOscillate(BBOBFunction function) {
        super(function);
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double[] tx = (double[])x.clone();
        for (int i = 0; i < x.length; ++i) {
            double base;
            double tmp;
            if (x[i] > 0.0) {
                tmp = Math.log(x[i]) / 0.1;
                base = Math.exp(tmp + 0.49 * (Math.sin(tmp) + Math.sin(0.79 * tmp)));
                tx[i] = Math.pow(base, 0.1);
                continue;
            }
            if (x[i] < 0.0) {
                tmp = Math.log(-x[i]) / 0.1;
                base = Math.exp(tmp + 0.49 * (Math.sin(0.55 * tmp) + Math.sin(0.31 * tmp)));
                tx[i] = -Math.pow(base, 0.1);
                continue;
            }
            tx[i] = 0.0;
        }
        EncodingUtils.setReal(solution, tx);
        this.function.evaluate(solution);
        EncodingUtils.setReal(solution, x);
    }
}

