/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBTransformation;
import org.moeaframework.problem.BBOB2016.BBOBUtils;

public class TransformVariablesXHat
extends BBOBTransformation {
    private final long seed;

    public TransformVariablesXHat(BBOBFunction function, long seed) {
        super(function);
        this.seed = seed;
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double[] tx = BBOBUtils.uniform(x.length, this.seed);
        for (int i = 0; i < x.length; ++i) {
            tx[i] = tx[i] - 0.5 < 0.0 ? -x[i] : x[i];
        }
        EncodingUtils.setReal(solution, tx);
        this.function.evaluate(solution);
        EncodingUtils.setReal(solution, x);
    }
}

