/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.BBOB2016;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.BBOB2016.BBOBFunction;
import org.moeaframework.problem.BBOB2016.BBOBTransformation;

public class TransformVariablesZHat
extends BBOBTransformation {
    private final double[] xopt;

    public TransformVariablesZHat(BBOBFunction function, double[] xopt) {
        super(function);
        this.xopt = xopt;
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double[] tx = (double[])x.clone();
        tx[0] = x[0];
        for (int i = 1; i < x.length; ++i) {
            tx[i] = x[i] + 0.25 * (x[i - 1] - 2.0 * Math.abs(this.xopt[i - 1]));
        }
        EncodingUtils.setReal(solution, tx);
        this.function.evaluate(solution);
        EncodingUtils.setReal(solution, x);
    }
}

