/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.CDTLZ;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.DTLZ.DTLZ3;

public class C1_DTLZ3
extends DTLZ3 {
    public C1_DTLZ3(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
    }

    public C1_DTLZ3(int numberOfObjectives) {
        super(numberOfObjectives);
    }

    @Override
    public int getNumberOfConstraints() {
        return 1;
    }

    @Override
    public void evaluate(Solution solution) {
        super.evaluate(solution);
        double sumsq = 0.0;
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            sumsq += Math.pow(solution.getObjective(i), 2.0);
        }
        double c = (sumsq - 16.0) * (sumsq - Math.pow(this.getR(), 2.0));
        solution.setConstraint(0, c >= 0.0 ? 0.0 : c);
    }

    private double getR() {
        if (this.numberOfObjectives <= 3) {
            return 9.0;
        }
        if (this.numberOfObjectives <= 8) {
            return 12.5;
        }
        return 15.0;
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, this.numberOfObjectives, 1);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new RealVariable(0.0, 1.0));
        }
        return solution;
    }
}

