/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.CDTLZ;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.DTLZ.DTLZ2;

public class C2_DTLZ2
extends DTLZ2 {
    public C2_DTLZ2(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
    }

    public C2_DTLZ2(int numberOfObjectives) {
        super(numberOfObjectives);
    }

    @Override
    public int getNumberOfConstraints() {
        return 1;
    }

    @Override
    public void evaluate(Solution solution) {
        super.evaluate(solution);
        double r = this.numberOfObjectives > 3 ? 0.5 : 0.4;
        double v1 = Double.POSITIVE_INFINITY;
        double v2 = 0.0;
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            double sum = Math.pow(solution.getObjective(i) - 1.0, 2.0);
            for (int j = 0; j < this.numberOfObjectives; ++j) {
                if (i == j) continue;
                sum += Math.pow(solution.getObjective(j), 2.0);
            }
            v1 = Math.min(v1, sum - Math.pow(r, 2.0));
            v2 += Math.pow(solution.getObjective(i) - 1.0 / Math.sqrt(this.numberOfObjectives), 2.0);
        }
        double c = Math.min(v1, v2 - Math.pow(r, 2.0));
        solution.setConstraint(0, c <= 0.0 ? 0.0 : c);
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, this.numberOfObjectives, 1);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new RealVariable(0.0, 1.0));
        }
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution;
        do {
            solution = super.generate();
            this.evaluate(solution);
        } while (solution.violatesConstraints());
        return solution;
    }
}

