/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.CDTLZ;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.CDTLZ.ConvexDTLZ2;

public class ConvexC2_DTLZ2
extends ConvexDTLZ2 {
    public ConvexC2_DTLZ2(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
    }

    public ConvexC2_DTLZ2(int numberOfObjectives) {
        super(numberOfObjectives);
    }

    @Override
    public int getNumberOfConstraints() {
        return 1;
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, this.numberOfObjectives, 1);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new RealVariable(0.0, 1.0));
        }
        return solution;
    }

    @Override
    public void evaluate(Solution solution) {
        int i;
        super.evaluate(solution);
        double lambda = 0.0;
        double c = 0.0;
        for (i = 0; i < this.numberOfObjectives; ++i) {
            lambda += solution.getObjective(i);
        }
        lambda /= (double)this.numberOfObjectives;
        for (i = 0; i < this.numberOfObjectives; ++i) {
            c += Math.pow(solution.getObjective(i) - lambda, 2.0);
        }
        solution.setConstraint(0, (c -= Math.pow(this.getR(), 2.0)) >= 0.0 ? 0.0 : c);
    }

    private double getR() {
        if (this.numberOfObjectives <= 5) {
            return 0.225;
        }
        if (this.numberOfObjectives <= 10) {
            return 0.26;
        }
        return 0.27;
    }
}

