/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.CEC2009;

class CEC2009 {
    private static final double PI = Math.PI;

    private CEC2009() {
    }

    private static double MYSIGN(double x) {
        return x > 0.0 ? 1.0 : -1.0;
    }

    public static void UF1(double[] x, double[] f, int nx) {
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            yj *= yj;
            if (j % 2 == 0) {
                sum2 += yj;
                ++count2;
                continue;
            }
            sum1 += yj;
            ++count1;
        }
        f[0] = x[0] + 2.0 * sum1 / (double)count1;
        f[1] = 1.0 - Math.sqrt(x[0]) + 2.0 * sum2 / (double)count2;
    }

    public static void UF2(double[] x, double[] f, int nx) {
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int j = 2; j <= nx; ++j) {
            double yj;
            if (j % 2 == 0) {
                yj = x[j - 1] - 0.3 * x[0] * (x[0] * Math.cos(75.39822368615503 * x[0] + 4.0 * (double)j * Math.PI / (double)nx) + 2.0) * Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            yj = x[j - 1] - 0.3 * x[0] * (x[0] * Math.cos(75.39822368615503 * x[0] + 4.0 * (double)j * Math.PI / (double)nx) + 2.0) * Math.cos(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            sum1 += yj * yj;
            ++count1;
        }
        f[0] = x[0] + 2.0 * sum1 / (double)count1;
        f[1] = 1.0 - Math.sqrt(x[0]) + 2.0 * sum2 / (double)count2;
    }

    public static void UF3(double[] x, double[] f, int nx) {
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double prod1 = 1.0;
        double prod2 = 1.0;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.pow(x[0], 0.5 * (1.0 + 3.0 * ((double)j - 2.0) / ((double)nx - 2.0)));
            double pj = Math.cos(20.0 * yj * Math.PI / Math.sqrt((double)j + 0.0));
            if (j % 2 == 0) {
                sum2 += yj * yj;
                prod2 *= pj;
                ++count2;
                continue;
            }
            sum1 += yj * yj;
            prod1 *= pj;
            ++count1;
        }
        f[0] = x[0] + 2.0 * (4.0 * sum1 - 2.0 * prod1 + 2.0) / (double)count1;
        f[1] = 1.0 - Math.sqrt(x[0]) + 2.0 * (4.0 * sum2 - 2.0 * prod2 + 2.0) / (double)count2;
    }

    public static void UF4(double[] x, double[] f, int nx) {
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            double hj = Math.abs(yj) / (1.0 + Math.exp(2.0 * Math.abs(yj)));
            if (j % 2 == 0) {
                sum2 += hj;
                ++count2;
                continue;
            }
            sum1 += hj;
            ++count1;
        }
        f[0] = x[0] + 2.0 * sum1 / (double)count1;
        f[1] = 1.0 - x[0] * x[0] + 2.0 * sum2 / (double)count2;
    }

    public static void UF5(double[] x, double[] f, int nx) {
        double hj;
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double N = 10.0;
        double E = 0.1;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            hj = 2.0 * yj * yj - Math.cos(Math.PI * 4 * yj) + 1.0;
            if (j % 2 == 0) {
                sum2 += hj;
                ++count2;
                continue;
            }
            sum1 += hj;
            ++count1;
        }
        hj = (0.5 / N + E) * Math.abs(Math.sin(2.0 * N * Math.PI * x[0]));
        f[0] = x[0] + hj + 2.0 * sum1 / (double)count1;
        f[1] = 1.0 - x[0] + hj + 2.0 * sum2 / (double)count2;
    }

    public static void UF6(double[] x, double[] f, int nx) {
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double prod1 = 1.0;
        double prod2 = 1.0;
        double N = 2.0;
        double E = 0.1;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            double pj = Math.cos(20.0 * yj * Math.PI / Math.sqrt((double)j + 0.0));
            if (j % 2 == 0) {
                sum2 += yj * yj;
                prod2 *= pj;
                ++count2;
                continue;
            }
            sum1 += yj * yj;
            prod1 *= pj;
            ++count1;
        }
        double hj = 2.0 * (0.5 / N + E) * Math.sin(2.0 * N * Math.PI * x[0]);
        if (hj < 0.0) {
            hj = 0.0;
        }
        f[0] = x[0] + hj + 2.0 * (4.0 * sum1 - 2.0 * prod1 + 2.0) / (double)count1;
        f[1] = 1.0 - x[0] + hj + 2.0 * (4.0 * sum2 - 2.0 * prod2 + 2.0) / (double)count2;
    }

    public static void UF7(double[] x, double[] f, int nx) {
        double yj;
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int j = 2; j <= nx; ++j) {
            yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            if (j % 2 == 0) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum1 += yj * yj;
            ++count1;
        }
        yj = Math.pow(x[0], 0.2);
        f[0] = yj + 2.0 * sum1 / (double)count1;
        f[1] = 1.0 - yj + 2.0 * sum2 / (double)count2;
    }

    public static void UF8(double[] x, double[] f, int nx) {
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        for (int j = 3; j <= nx; ++j) {
            double yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)nx);
            if (j % 3 == 1) {
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum3 += yj * yj;
            ++count3;
        }
        f[0] = Math.cos(1.5707963267948966 * x[0]) * Math.cos(1.5707963267948966 * x[1]) + 2.0 * sum1 / (double)count1;
        f[1] = Math.cos(1.5707963267948966 * x[0]) * Math.sin(1.5707963267948966 * x[1]) + 2.0 * sum2 / (double)count2;
        f[2] = Math.sin(1.5707963267948966 * x[0]) + 2.0 * sum3 / (double)count3;
    }

    public static void UF9(double[] x, double[] f, int nx) {
        double yj;
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double E = 0.1;
        for (int j = 3; j <= nx; ++j) {
            yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)nx);
            if (j % 3 == 1) {
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum3 += yj * yj;
            ++count3;
        }
        yj = (1.0 + E) * (1.0 - 4.0 * (2.0 * x[0] - 1.0) * (2.0 * x[0] - 1.0));
        if (yj < 0.0) {
            yj = 0.0;
        }
        f[0] = 0.5 * (yj + 2.0 * x[0]) * x[1] + 2.0 * sum1 / (double)count1;
        f[1] = 0.5 * (yj - 2.0 * x[0] + 2.0) * x[1] + 2.0 * sum2 / (double)count2;
        f[2] = 1.0 - x[1] + 2.0 * sum3 / (double)count3;
    }

    public static void UF10(double[] x, double[] f, int nx) {
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        for (int j = 3; j <= nx; ++j) {
            double yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)nx);
            double hj = 4.0 * yj * yj - Math.cos(Math.PI * 8 * yj) + 1.0;
            if (j % 3 == 1) {
                sum1 += hj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += hj;
                ++count2;
                continue;
            }
            sum3 += hj;
            ++count3;
        }
        f[0] = Math.cos(1.5707963267948966 * x[0]) * Math.cos(1.5707963267948966 * x[1]) + 2.0 * sum1 / (double)count1;
        f[1] = Math.cos(1.5707963267948966 * x[0]) * Math.sin(1.5707963267948966 * x[1]) + 2.0 * sum2 / (double)count2;
        f[2] = Math.sin(1.5707963267948966 * x[0]) + 2.0 * sum3 / (double)count3;
    }

    public static void CF1(double[] x, double[] f, double[] c, int nx) {
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double N = 10.0;
        double a = 1.0;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.pow(x[0], 0.5 * (1.0 + 3.0 * ((double)j - 2.0) / ((double)nx - 2.0)));
            if (j % 2 == 1) {
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            sum2 += yj * yj;
            ++count2;
        }
        f[0] = x[0] + 2.0 * sum1 / (double)count1;
        f[1] = 1.0 - x[0] + 2.0 * sum2 / (double)count2;
        c[0] = f[1] + f[0] - a * Math.abs(Math.sin(N * Math.PI * (f[0] - f[1] + 1.0))) - 1.0;
    }

    public static void CF2(double[] x, double[] f, double[] c, int nx) {
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double N = 2.0;
        double a = 1.0;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            if (j % 2 == 1) {
                yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            yj = x[j - 1] - Math.cos(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            sum2 += yj * yj;
            ++count2;
        }
        f[0] = x[0] + 2.0 * sum1 / (double)count1;
        f[1] = 1.0 - Math.sqrt(x[0]) + 2.0 * sum2 / (double)count2;
        double t = f[1] + Math.sqrt(f[0]) - a * Math.sin(N * Math.PI * (Math.sqrt(f[0]) - f[1] + 1.0)) - 1.0;
        c[0] = CEC2009.MYSIGN(t) * Math.abs(t) / (1.0 + Math.exp(4.0 * Math.abs(t)));
    }

    public static void CF3(double[] x, double[] f, double[] c, int nx) {
        int count1 = 0;
        int count2 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double prod1 = 1.0;
        double prod2 = 1.0;
        double N = 2.0;
        double a = 1.0;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            double pj = Math.cos(20.0 * yj * Math.PI / Math.sqrt((double)j + 0.0));
            if (j % 2 == 0) {
                sum2 += yj * yj;
                prod2 *= pj;
                ++count2;
                continue;
            }
            sum1 += yj * yj;
            prod1 *= pj;
            ++count1;
        }
        f[0] = x[0] + 2.0 * (4.0 * sum1 - 2.0 * prod1 + 2.0) / (double)count1;
        f[1] = 1.0 - x[0] * x[0] + 2.0 * (4.0 * sum2 - 2.0 * prod2 + 2.0) / (double)count2;
        c[0] = f[1] + f[0] * f[0] - a * Math.sin(N * Math.PI * (f[0] * f[0] - f[1] + 1.0)) - 1.0;
    }

    public static void CF4(double[] x, double[] f, double[] c, int nx) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int j = 2; j <= nx; ++j) {
            double yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            if (j % 2 == 1) {
                sum1 += yj * yj;
                continue;
            }
            if (j == 2) {
                sum2 += yj < 1.5 - 0.75 * Math.sqrt(2.0) ? Math.abs(yj) : 0.125 + (yj - 1.0) * (yj - 1.0);
                continue;
            }
            sum2 += yj * yj;
        }
        f[0] = x[0] + sum1;
        f[1] = 1.0 - x[0] + sum2;
        double t = x[1] - Math.sin(6.0 * x[0] * Math.PI + Math.PI * 2 / (double)nx) - 0.5 * x[0] + 0.25;
        c[0] = CEC2009.MYSIGN(t) * Math.abs(t) / (1.0 + Math.exp(4.0 * Math.abs(t)));
    }

    public static void CF5(double[] x, double[] f, double[] c, int nx) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int j = 2; j <= nx; ++j) {
            double yj;
            if (j % 2 == 1) {
                yj = x[j - 1] - 0.8 * x[0] * Math.cos(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
                sum1 += 2.0 * yj * yj - Math.cos(Math.PI * 4 * yj) + 1.0;
                continue;
            }
            yj = x[j - 1] - 0.8 * x[0] * Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            if (j == 2) {
                sum2 += yj < 1.5 - 0.75 * Math.sqrt(2.0) ? Math.abs(yj) : 0.125 + (yj - 1.0) * (yj - 1.0);
                continue;
            }
            sum2 += 2.0 * yj * yj - Math.cos(Math.PI * 4 * yj) + 1.0;
        }
        f[0] = x[0] + sum1;
        f[1] = 1.0 - x[0] + sum2;
        c[0] = x[1] - 0.8 * x[0] * Math.sin(6.0 * x[0] * Math.PI + Math.PI * 2 / (double)nx) - 0.5 * x[0] + 0.25;
    }

    public static void CF6(double[] x, double[] f, double[] c, int nx) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int j = 2; j <= nx; ++j) {
            double yj;
            if (j % 2 == 1) {
                yj = x[j - 1] - 0.8 * x[0] * Math.cos(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
                sum1 += yj * yj;
                continue;
            }
            yj = x[j - 1] - 0.8 * x[0] * Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            sum2 += yj * yj;
        }
        f[0] = x[0] + sum1;
        f[1] = (1.0 - x[0]) * (1.0 - x[0]) + sum2;
        c[0] = x[1] - 0.8 * x[0] * Math.sin(6.0 * x[0] * Math.PI + Math.PI * 2 / (double)nx) - CEC2009.MYSIGN((x[0] - 0.5) * (1.0 - x[0])) * Math.sqrt(Math.abs((x[0] - 0.5) * (1.0 - x[0])));
        c[1] = x[3] - 0.8 * x[0] * Math.sin(6.0 * x[0] * Math.PI + Math.PI * 4 / (double)nx) - CEC2009.MYSIGN(0.25 * Math.sqrt(1.0 - x[0]) - 0.5 * (1.0 - x[0])) * Math.sqrt(Math.abs(0.25 * Math.sqrt(1.0 - x[0]) - 0.5 * (1.0 - x[0])));
    }

    public static void CF7(double[] x, double[] f, double[] c, int nx) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int j = 2; j <= nx; ++j) {
            double yj;
            if (j % 2 == 1) {
                yj = x[j - 1] - Math.cos(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
                sum1 += 2.0 * yj * yj - Math.cos(Math.PI * 4 * yj) + 1.0;
                continue;
            }
            yj = x[j - 1] - Math.sin(Math.PI * 6 * x[0] + (double)j * Math.PI / (double)nx);
            if (j == 2 || j == 4) {
                sum2 += yj * yj;
                continue;
            }
            sum2 += 2.0 * yj * yj - Math.cos(Math.PI * 4 * yj) + 1.0;
        }
        f[0] = x[0] + sum1;
        f[1] = (1.0 - x[0]) * (1.0 - x[0]) + sum2;
        c[0] = x[1] - Math.sin(6.0 * x[0] * Math.PI + Math.PI * 2 / (double)nx) - CEC2009.MYSIGN((x[0] - 0.5) * (1.0 - x[0])) * Math.sqrt(Math.abs((x[0] - 0.5) * (1.0 - x[0])));
        c[1] = x[3] - Math.sin(6.0 * x[0] * Math.PI + Math.PI * 4 / (double)nx) - CEC2009.MYSIGN(0.25 * Math.sqrt(1.0 - x[0]) - 0.5 * (1.0 - x[0])) * Math.sqrt(Math.abs(0.25 * Math.sqrt(1.0 - x[0]) - 0.5 * (1.0 - x[0])));
    }

    public static void CF8(double[] x, double[] f, double[] c, int nx) {
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double N = 2.0;
        double a = 4.0;
        for (int j = 3; j <= nx; ++j) {
            double yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)nx);
            if (j % 3 == 1) {
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum3 += yj * yj;
            ++count3;
        }
        f[0] = Math.cos(1.5707963267948966 * x[0]) * Math.cos(1.5707963267948966 * x[1]) + 2.0 * sum1 / (double)count1;
        f[1] = Math.cos(1.5707963267948966 * x[0]) * Math.sin(1.5707963267948966 * x[1]) + 2.0 * sum2 / (double)count2;
        f[2] = Math.sin(1.5707963267948966 * x[0]) + 2.0 * sum3 / (double)count3;
        c[0] = (f[0] * f[0] + f[1] * f[1]) / (1.0 - f[2] * f[2]) - a * Math.abs(Math.sin(N * Math.PI * ((f[0] * f[0] - f[1] * f[1]) / (1.0 - f[2] * f[2]) + 1.0))) - 1.0;
    }

    public static void CF9(double[] x, double[] f, double[] c, int nx) {
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double N = 2.0;
        double a = 3.0;
        for (int j = 3; j <= nx; ++j) {
            double yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)nx);
            if (j % 3 == 1) {
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum3 += yj * yj;
            ++count3;
        }
        f[0] = Math.cos(1.5707963267948966 * x[0]) * Math.cos(1.5707963267948966 * x[1]) + 2.0 * sum1 / (double)count1;
        f[1] = Math.cos(1.5707963267948966 * x[0]) * Math.sin(1.5707963267948966 * x[1]) + 2.0 * sum2 / (double)count2;
        f[2] = Math.sin(1.5707963267948966 * x[0]) + 2.0 * sum3 / (double)count3;
        c[0] = (f[0] * f[0] + f[1] * f[1]) / (1.0 - f[2] * f[2]) - a * Math.sin(N * Math.PI * ((f[0] * f[0] - f[1] * f[1]) / (1.0 - f[2] * f[2]) + 1.0)) - 1.0;
    }

    public static void CF10(double[] x, double[] f, double[] c, int nx) {
        int count1 = 0;
        int count2 = 0;
        int count3 = 0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double N = 2.0;
        double a = 1.0;
        for (int j = 3; j <= nx; ++j) {
            double yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)nx);
            double hj = 4.0 * yj * yj - Math.cos(Math.PI * 8 * yj) + 1.0;
            if (j % 3 == 1) {
                sum1 += hj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += hj;
                ++count2;
                continue;
            }
            sum3 += hj;
            ++count3;
        }
        f[0] = Math.cos(1.5707963267948966 * x[0]) * Math.cos(1.5707963267948966 * x[1]) + 2.0 * sum1 / (double)count1;
        f[1] = Math.cos(1.5707963267948966 * x[0]) * Math.sin(1.5707963267948966 * x[1]) + 2.0 * sum2 / (double)count2;
        f[2] = Math.sin(1.5707963267948966 * x[0]) + 2.0 * sum3 / (double)count3;
        c[0] = (f[0] * f[0] + f[1] * f[1]) / (1.0 - f[2] * f[2]) - a * Math.sin(N * Math.PI * ((f[0] * f[0] - f[1] * f[1]) / (1.0 - f[2] * f[2]) + 1.0)) - 1.0;
    }

    public static void transform(double[] x, double[] zz, double[] psum, double[][] M, double[] lamda_l, int nx, int n_obj) {
        int i;
        int k = nx - n_obj + 1;
        double[] p = new double[nx];
        for (i = 0; i < nx; ++i) {
            double z = 0.0;
            for (int j = 0; j < nx; ++j) {
                z += M[i][j] * x[j];
            }
            if (z >= 0.0 && z <= 1.0) {
                zz[i] = z;
                p[i] = 0.0;
                continue;
            }
            if (z < 0.0) {
                zz[i] = -lamda_l[i] * z;
                p[i] = -z;
                continue;
            }
            zz[i] = 1.0 - lamda_l[i] * (z - 1.0);
            p[i] = z - 1.0;
        }
        for (int j = 0; j < n_obj; ++j) {
            psum[j] = 0.0;
        }
        for (i = nx - k + 1; i <= nx; ++i) {
            for (int j = 0; j < n_obj; ++j) {
                psum[j] = Math.sqrt(Math.pow(psum[j], 2.0) + Math.pow(p[i - 1], 2.0));
            }
        }
        for (i = 1; i <= n_obj; ++i) {
            for (int j = n_obj - i; j >= 1; --j) {
                psum[i - 1] = Math.sqrt(Math.pow(psum[i - 1], 2.0) + Math.pow(p[j - 1], 2.0));
            }
            if (i <= 1) continue;
            psum[i - 1] = Math.sqrt(Math.pow(psum[i - 1], 2.0) + Math.pow(p[n_obj - i + 1 - 1], 2.0));
        }
    }
}

