/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.CEC2009;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.CEC2009.CEC2009;
import org.moeaframework.problem.DTLZ.DTLZ2;

public class UF11
extends AbstractProblem {
    private static final double[][] bound_10D = new double[][]{{-1.118, -0.951, -2.055, -0.472, -1.07, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.899, 1.257, 0.0, 1.244, 0.869, 1.0, 1.0, 1.0, 1.0, 1.0}};
    private static final double[][] M_10D = new double[][]{{0.0346, -0.7523, 0.3561, -0.2958, 0.4675, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.8159, -0.0423, 0.4063, 0.3455, -0.2192, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.3499, 0.3421, 0.8227, -0.219, -0.1889, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.0963, -0.4747, -0.0998, -0.2429, -0.8345, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.4487, -0.2998, 0.146, 0.8283, -0.0363, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    private static final double[] lamda_l_10D = new double[]{0.313, 0.312, 0.321, 0.316, 0.456, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[][] bound_30D = new double[][]{{-1.773, -1.846, -1.053, -2.37, -1.603, -1.878, -1.677, -0.935, -1.891, -0.964, -0.885, -1.69, -2.235, -1.541, -0.72, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.403, 1.562, 2.009, 0.976, 1.49, 1.334, 1.074, 2.354, 1.462, 2.372, 2.267, 1.309, 0.842, 1.665, 2.476, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}};
    private static final double[][] M_30D = new double[][]{{0.0128, 0.2165, 0.4374, -0.08, 0.0886, -0.2015, 0.1071, 0.2886, 0.2354, 0.2785, -0.1748, 0.2147, 0.1649, -0.3043, 0.5316, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.4813, 0.242, -0.3663, -0.042, -0.0088, -0.4945, -0.3073, 0.199, 0.0441, -0.0627, 0.0191, 0.388, -0.0618, -0.0319, -0.1833, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.4816, -0.2254, 0.0663, 0.4801, 0.2009, -8.0E-4, -0.1501, 0.0269, -0.2037, 0.4334, -0.2157, -0.3175, -0.0923, 0.1451, 0.1118, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.0876, -0.2667, -0.0063, 0.2114, 0.4506, 0.0823, -0.0125, 0.2313, 0.084, -0.2376, 0.1938, -0.003, 0.3391, 0.0863, 0.1231, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.1025, 0.4011, -0.0117, 0.2076, 0.2585, 0.1124, -0.0288, 0.3095, -0.6146, -0.2376, 0.1938, -0.003, 0.3391, 0.0863, 0.1231, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.4543, -0.2761, -0.2985, -0.2837, 0.0634, 0.107, 0.2996, -0.269, -0.1634, -0.1452, 0.1799, -0.0014, 0.2394, -0.2745, 0.3969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.1422, -0.4364, 0.0751, -0.2235, 0.3966, -0.0252, 0.0908, 0.0477, -0.2254, 0.1801, -0.0552, 0.577, -0.0396, 0.3765, -0.0522, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.3542, -0.2245, 0.3497, -0.1609, -0.1107, 0.0079, 0.2241, 0.4517, 0.1309, -0.3355, -0.1123, -0.1831, 0.3, 0.2045, -0.3191, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {5.0E-4, 0.0377, -0.2808, -0.0641, 0.1316, 0.2191, 0.0207, 0.3308, 0.4117, 0.3839, 0.5775, -0.1219, 0.1192, 0.2435, 0.0414, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.1177, -1.0E-4, -0.1992, -0.4533, 0.4234, -0.0191, -0.374, 0.1325, 0.0972, -0.2042, -0.3493, -0.4018, -0.1087, 0.0918, 0.2217, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.1818, 0.3022, -0.1388, -0.238, -0.0773, 0.6463, 0.045, 0.103, -0.0958, 0.2837, -0.3969, 0.1779, -0.0251, -0.1543, -0.2452, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.1889, -0.4397, -0.2206, 0.0981, -0.5203, 0.1325, -0.3427, 0.4242, -0.1271, -0.0291, -0.0795, 0.1213, 0.0565, -0.1092, 0.272, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.1808, -0.0624, -0.2689, 0.2289, 0.1128, -0.0844, -0.0549, -0.2202, 0.245, 0.0825, -0.3319, 0.0513, 0.7523, 0.0043, -0.1472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.0983, 0.0611, -0.4145, 0.3017, 0.041, -0.0703, 0.625, 0.2449, 0.1307, -0.1714, -0.3045, 0.0218, -0.2837, 0.1408, 0.1633, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.2026, 0.0324, 0.1496, 0.3129, 0.1437, 0.4331, -0.2629, -0.1498, 0.3746, -0.4366, 0.0163, 0.3316, -0.0697, 0.1833, 0.2412, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    private static final double[] lamda_l_30D = new double[]{0.113, 0.105, 0.117, 0.119, 0.108, 0.11, 0.101, 0.107, 0.111, 0.109, 0.12, 0.108, 0.101, 0.105, 0.116, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final DTLZ2 problem;

    public UF11() {
        this(30, 5);
    }

    public UF11(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
        if (numberOfVariables != 10 && numberOfVariables != 30) {
            throw new IllegalArgumentException("number of variables must be 10 or 30");
        }
        this.problem = new DTLZ2(numberOfVariables, numberOfObjectives);
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double[] psum = new double[this.numberOfObjectives];
        double[] zz = new double[this.numberOfVariables];
        CEC2009.transform(x, zz, psum, this.numberOfVariables == 10 ? M_10D : M_30D, this.numberOfVariables == 10 ? lamda_l_10D : lamda_l_30D, this.numberOfVariables, this.numberOfObjectives);
        Solution transformedSolution = this.problem.newSolution();
        EncodingUtils.setReal(transformedSolution, zz);
        this.problem.evaluate(transformedSolution);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            solution.setObjective(i, 2.0 / (1.0 + Math.exp(-psum[i])) * (transformedSolution.getObjective(i) + 1.0));
        }
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, this.numberOfObjectives);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new RealVariable(this.numberOfVariables == 10 ? bound_10D[0][i] : bound_30D[0][i], this.numberOfVariables == 10 ? bound_10D[1][i] : bound_30D[1][i]));
        }
        return solution;
    }
}

