/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.CEC2009;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.CEC2009.CEC2009;
import org.moeaframework.problem.DTLZ.DTLZ3;

public class UF12
extends AbstractProblem {
    private static final double[][] bound_10D = new double[][]{{-1.118, -0.951, -2.055, -0.472, -1.07, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.899, 1.257, 0.0, 1.244, 0.869, 1.0, 1.0, 1.0, 1.0, 1.0}};
    private static final double[][] M_10D = new double[][]{{-0.2861, 0.2796, -0.8507, 0.2837, 0.1893, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.2837, 0.8861, 0.1219, -0.3157, 0.1407, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.6028, 0.1119, -0.081, 0.5963, -0.5119, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.645, 0.3465, 0.4447, 0.4753, -0.2005, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.2414, -0.0635, 0.2391, 0.4883, 0.8013, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    private static final double[] lamda_l_10D = new double[]{0.313, 0.312, 0.321, 0.316, 0.456, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[][] bound_30D = new double[][]{{-1.773, -1.846, -1.053, -2.37, -1.603, -1.878, -1.677, -0.935, -1.891, -0.964, -0.885, -1.69, -2.235, -1.541, -0.72, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.403, 1.562, 2.009, 0.976, 1.49, 1.334, 1.074, 2.354, 1.462, 2.372, 2.267, 1.309, 0.842, 1.665, 2.476, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}};
    private static final double[][] M_30D = new double[][]{{-0.1565, -0.2418, 0.5427, -0.2191, 0.2522, -0.0563, 0.1991, 0.1166, 0.214, -0.0973, -0.0755, 0.4073, 0.4279, -0.1876, -0.0968, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.1477, -0.2396, -0.0022, 0.418, 0.2675, -0.1365, -0.0729, 0.4761, -0.0685, 0.2105, 0.1388, 0.1465, -0.0256, 0.0292, 0.5767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0322, 0.3727, -0.0467, 0.1651, -0.0672, 0.0638, -0.1168, 0.4055, 0.6714, -0.1948, -0.1451, 0.1734, -0.2788, -0.0769, -0.1433, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.3688, 0.1935, 0.3691, 0.4298, 0.234, 0.2593, -0.3081, -0.2013, -0.2779, -0.0932, 3.0E-4, 0.0149, -0.2303, -0.3261, -0.0517, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.058, -0.0609, 4.0E-4, -0.1831, 3.0E-4, 0.4742, -0.253, -0.075, 0.0839, 0.1606, 0.602, 0.4103, -0.0857, 0.2954, -0.0819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.2145, -0.0056, -0.0251, 0.2288, -0.487, -0.5486, 0.1253, -0.1512, -0.039, 0.0722, 0.3074, 0.416, -0.1304, -0.161, -0.0848, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.2557, -0.1087, 0.0679, -0.312, 0.3567, -0.4644, -0.3535, 0.106, -0.2158, -0.133, -0.0154, 0.0911, -0.4154, 0.0356, -0.3085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.2303, 0.4996, 0.1883, 0.187, 0.185, -0.0216, 0.4409, -0.0573, -0.2396, 0.1471, -0.154, 0.2731, -0.0398, 0.4505, -0.1131, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-0.1576, -0.0023, 0.2588, 0.2105, 0.225, -0.2978, 0.0175, -0.1157, 0.3717, 0.0562, 0.4068, -0.5081, 0.0718, 0.3443, -0.1488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.1047, -0.0568, -0.2771, 0.3803, 0.0046, 0.0188, -0.15, 0.2053, -0.229, -0.4582, 0.1191, 0.0639, 0.4946, 0.1121, -0.4018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.3943, -0.0374, 0.3004, 0.1472, -0.2988, 0.0443, -0.2483, 0.135, -0.016, 0.5834, -0.1095, -0.1398, 0.1711, -0.1867, -0.3518, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.1244, -0.6134, 0.1823, 0.3012, -0.1968, 0.1616, 0.1025, -0.1972, 0.1162, -0.2079, -0.3062, 0.0585, -0.3286, 0.3187, -0.0812, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.1832, -0.1559, -0.4327, 0.2059, 0.4677, 0.0317, 0.2233, -0.3589, 0.2393, 0.2468, 0.0148, 0.1193, -0.0279, -0.36, -0.2261, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.5027, 0.1935, 0.1571, 0.0503, -0.0503, -0.1443, -0.308, -0.4939, 0.1847, -0.2762, 0.0042, 0.096, 0.2239, -0.0579, 0.384, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.3948, -2.0E-4, 0.2172, -0.0293, -0.0835, 0.1614, 0.4559, 0.1626, -0.1155, -0.3087, 0.4331, -0.2223, -0.2213, -0.3658, -0.0188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    private static final double[] lamda_l_30D = new double[]{0.113, 0.105, 0.117, 0.119, 0.108, 0.11, 0.101, 0.107, 0.111, 0.109, 0.12, 0.108, 0.101, 0.105, 0.116, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final DTLZ3 problem;

    public UF12() {
        this(30, 5);
    }

    public UF12(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
        if (numberOfVariables != 10 && numberOfVariables != 30) {
            throw new IllegalArgumentException("number of variables must be 10 or 30");
        }
        this.problem = new DTLZ3(numberOfVariables, numberOfObjectives);
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double[] psum = new double[this.numberOfObjectives];
        double[] zz = new double[this.numberOfVariables];
        CEC2009.transform(x, zz, psum, this.numberOfVariables == 10 ? M_10D : M_30D, this.numberOfVariables == 10 ? lamda_l_10D : lamda_l_30D, this.numberOfVariables, this.numberOfObjectives);
        Solution transformedSolution = this.problem.newSolution();
        EncodingUtils.setReal(transformedSolution, zz);
        this.problem.evaluate(transformedSolution);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            solution.setObjective(i, 2.0 / (1.0 + Math.exp(-psum[i])) * (transformedSolution.getObjective(i) + 1.0));
        }
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, this.numberOfObjectives);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new RealVariable(this.numberOfVariables == 10 ? bound_10D[0][i] : bound_30D[0][i], this.numberOfVariables == 10 ? bound_10D[1][i] : bound_30D[1][i]));
        }
        return solution;
    }
}

