/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.DTLZ;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.DTLZ.DTLZ;

public class DTLZ2
extends DTLZ {
    public DTLZ2(int numberOfObjectives) {
        this(numberOfObjectives + 9, numberOfObjectives);
    }

    public DTLZ2(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
    }

    @Override
    public void evaluate(Solution solution) {
        int i;
        double[] x = EncodingUtils.getReal(solution);
        double[] f = new double[this.numberOfObjectives];
        int k = this.numberOfVariables - this.numberOfObjectives + 1;
        double g = 0.0;
        for (i = this.numberOfVariables - k; i < this.numberOfVariables; ++i) {
            g += Math.pow(x[i] - 0.5, 2.0);
        }
        for (i = 0; i < this.numberOfObjectives; ++i) {
            f[i] = 1.0 + g;
            for (int j = 0; j < this.numberOfObjectives - i - 1; ++j) {
                int n = i;
                f[n] = f[n] * Math.cos(1.5707963267948966 * x[j]);
            }
            if (i == 0) continue;
            int n = i;
            f[n] = f[n] * Math.sin(1.5707963267948966 * x[this.numberOfObjectives - i - 1]);
        }
        solution.setObjectives(f);
    }

    @Override
    public Solution generate() {
        int i;
        Solution solution = this.newSolution();
        for (i = 0; i < this.numberOfObjectives - 1; ++i) {
            ((RealVariable)solution.getVariable(i)).setValue(PRNG.nextDouble());
        }
        for (i = this.numberOfObjectives - 1; i < this.numberOfVariables; ++i) {
            ((RealVariable)solution.getVariable(i)).setValue(0.5);
        }
        this.evaluate(solution);
        return solution;
    }
}

