/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.DTLZ;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.DTLZ.DTLZ;

public class DTLZ7
extends DTLZ {
    public DTLZ7(int numberOfObjectives) {
        this(numberOfObjectives + 19, numberOfObjectives);
    }

    public DTLZ7(int numberOfVariables, int numberOfObjectives) {
        super(numberOfVariables, numberOfObjectives);
    }

    @Override
    public void evaluate(Solution solution) {
        int i;
        double[] x = EncodingUtils.getReal(solution);
        double[] f = new double[this.numberOfObjectives];
        int k = this.numberOfVariables - this.numberOfObjectives + 1;
        double g = 0.0;
        for (int i2 = this.numberOfVariables - k; i2 < this.numberOfVariables; ++i2) {
            g += x[i2];
        }
        g = 1.0 + 9.0 * g / (double)k;
        double h = this.numberOfObjectives;
        for (i = 0; i < this.numberOfObjectives - 1; ++i) {
            h -= x[i] / (1.0 + g) * (1.0 + Math.sin(Math.PI * 3 * x[i]));
        }
        for (i = 0; i < this.numberOfObjectives - 1; ++i) {
            f[i] = x[i];
        }
        f[this.numberOfObjectives - 1] = (1.0 + g) * h;
        solution.setObjectives(f);
    }

    @Override
    public Solution generate() {
        int i;
        Solution solution = this.newSolution();
        for (i = 0; i < this.numberOfObjectives - 1; ++i) {
            ((RealVariable)solution.getVariable(i)).setValue(PRNG.nextDouble());
        }
        for (i = this.numberOfObjectives - 1; i < this.numberOfVariables; ++i) {
            ((RealVariable)solution.getVariable(i)).setValue(0.0);
        }
        this.evaluate(solution);
        return solution;
    }
}

