/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.variable.BinaryVariable;
import org.moeaframework.core.variable.Permutation;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.ProblemException;
import org.moeaframework.util.io.RedirectStream;

public abstract class ExternalProblem
implements Problem {
    public static final int DEFAULT_PORT = 16801;
    private final BufferedReader reader;
    private final BufferedWriter writer;

    public ExternalProblem(String ... command) throws IOException {
        this(new ProcessBuilder(command).start());
    }

    public ExternalProblem(String host, int port) throws IOException, UnknownHostException {
        this(new Socket(host, port));
    }

    public ExternalProblem(InetAddress address, int port) throws IOException {
        this(new Socket(address, port));
    }

    ExternalProblem(Socket socket) throws IOException {
        this(socket.getInputStream(), socket.getOutputStream());
    }

    ExternalProblem(Process process) {
        this(process.getInputStream(), process.getOutputStream());
        RedirectStream.redirect(process.getErrorStream(), System.err);
    }

    ExternalProblem(InputStream input, OutputStream output) {
        this.reader = new BufferedReader(new InputStreamReader(input));
        this.writer = new BufferedWriter(new OutputStreamWriter(output));
    }

    @Override
    public synchronized void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new ProblemException((Problem)this, (Throwable)e);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new ProblemException((Problem)this, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void evaluate(Solution solution) throws ProblemException {
        try {
            this.writer.write(this.encode(solution.getVariable(0)));
            for (int i = 1; i < solution.getNumberOfVariables(); ++i) {
                this.writer.write(" ");
                this.writer.write(this.encode(solution.getVariable(i)));
            }
            this.writer.newLine();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ProblemException(this, "error sending variables to external process", e);
        }
        try {
            int i;
            String line = this.reader.readLine();
            if (line == null) {
                throw new ProblemException((Problem)this, "end of stream reached when response expected");
            }
            String[] tokens = line.split("\\s+");
            if (tokens.length != solution.getNumberOfObjectives() + solution.getNumberOfConstraints()) {
                throw new ProblemException((Problem)this, "response contained fewer tokens than expected");
            }
            int index = 0;
            for (i = 0; i < solution.getNumberOfObjectives(); ++i) {
                solution.setObjective(i, Double.parseDouble(tokens[index]));
                ++index;
            }
            for (i = 0; i < solution.getNumberOfConstraints(); ++i) {
                solution.setConstraint(i, Double.parseDouble(tokens[index]));
                ++index;
            }
        }
        catch (IOException e) {
            throw new ProblemException(this, "error receiving variables from external process", e);
        }
        catch (NumberFormatException e) {
            throw new ProblemException(this, "error receiving variables from external process", e);
        }
    }

    private String encode(Variable variable) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (variable instanceof RealVariable) {
            RealVariable rv = (RealVariable)variable;
            sb.append(rv.getValue());
        } else if (variable instanceof BinaryVariable) {
            BinaryVariable bv = (BinaryVariable)variable;
            for (int i = 0; i < bv.getNumberOfBits(); ++i) {
                sb.append(bv.get(i) ? "1" : "0");
            }
        } else if (variable instanceof Permutation) {
            Permutation p = (Permutation)variable;
            for (int i = 0; i < p.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(p.get(i));
            }
        } else {
            throw new IOException("unable to serialize variable");
        }
        return sb.toString();
    }
}

