/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.LZ;

import java.util.ArrayList;
import java.util.List;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.AbstractProblem;

public abstract class LZ
extends AbstractProblem {
    private final int pType;
    private final int lType;
    private final int dType;

    public LZ(int numberOfVariables, int numberOfObjectives, int pType, int lType, int dType) {
        super(numberOfVariables, numberOfObjectives);
        this.pType = pType;
        this.lType = lType;
        this.dType = dType;
        this.validate();
    }

    public int getPType() {
        return this.pType;
    }

    public int getLType() {
        return this.lType;
    }

    public int getDType() {
        return this.dType;
    }

    @Override
    public void evaluate(Solution solution) {
        solution.setObjectives(this.evaluate(EncodingUtils.getReal(solution)));
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, this.numberOfObjectives);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new RealVariable(0.0, 1.0));
        }
        return solution;
    }

    private void validate() {
        if (this.numberOfObjectives < 2 || this.numberOfObjectives > 3) {
            throw new IllegalArgumentException("invalid number of objectives");
        }
        if (this.numberOfObjectives == 2 ? this.pType < 21 || this.pType > 24 : this.numberOfObjectives == 3 && (this.pType < 31 || this.pType > 34)) {
            throw new IllegalArgumentException("invalid ptype");
        }
        if (this.dType < 1 || this.dType > 4) {
            throw new IllegalArgumentException("invalid dtype");
        }
        if (this.numberOfObjectives == 2 ? this.lType < 21 || this.lType > 26 : this.lType < 31 || this.lType > 32) {
            throw new IllegalArgumentException("invalid ltype");
        }
    }

    private double[] alphafunction(double[] x) {
        if (this.numberOfObjectives == 2) {
            if (this.pType == 21) {
                return new double[]{x[0], 1.0 - Math.sqrt(x[0])};
            }
            if (this.pType == 22) {
                return new double[]{x[0], 1.0 - x[0] * x[0]};
            }
            if (this.pType == 23) {
                return new double[]{x[0], 1.0 - Math.sqrt(x[0]) - x[0] * Math.sin(10.0 * x[0] * x[0] * Math.PI)};
            }
            if (this.pType == 24) {
                return new double[]{x[0], 1.0 - x[0] - 0.05 * Math.sin(Math.PI * 4 * x[0])};
            }
            throw new IllegalStateException();
        }
        if (this.numberOfObjectives == 3) {
            if (this.pType == 31) {
                return new double[]{Math.cos(x[0] * Math.PI / 2.0) * Math.cos(x[1] * Math.PI / 2.0), Math.cos(x[0] * Math.PI / 2.0) * Math.sin(x[1] * Math.PI / 2.0), Math.sin(x[0] * Math.PI / 2.0)};
            }
            if (this.pType == 32) {
                return new double[]{1.0 - Math.cos(x[0] * Math.PI / 2.0) * Math.cos(x[1] * Math.PI / 2.0), 1.0 - Math.cos(x[0] * Math.PI / 2.0) * Math.sin(x[1] * Math.PI / 2.0), 1.0 - Math.sin(x[0] * Math.PI / 2.0)};
            }
            if (this.pType == 33) {
                return new double[]{x[0], x[1], 3.0 - (Math.sin(Math.PI * 3 * x[0]) + Math.sin(Math.PI * 3 * x[1])) - 2.0 * (x[0] + x[1])};
            }
            if (this.pType == 34) {
                return new double[]{x[0] * x[1], x[0] * (1.0 - x[1]), 1.0 - x[0]};
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    private double betafunction(double[] x) {
        int dim = x.length;
        if (this.dType == 1) {
            double beta = 0.0;
            for (int i = 0; i < dim; ++i) {
                beta += x[i] * x[i];
            }
            return 2.0 * beta / (double)dim;
        }
        if (this.dType == 2) {
            double beta = 0.0;
            for (int i = 0; i < dim; ++i) {
                beta += Math.sqrt(i + 1) * x[i] * x[i];
            }
            return 2.0 * beta / (double)dim;
        }
        if (this.dType == 3) {
            double sum = 0.0;
            for (int i = 0; i < dim; ++i) {
                double xx = 2.0 * x[i];
                sum += xx * xx - Math.cos(Math.PI * 4 * xx) + 1.0;
            }
            return 2.0 * sum / (double)dim;
        }
        if (this.dType == 4) {
            double sum = 0.0;
            double prod = 1.0;
            for (int i = 0; i < dim; ++i) {
                double xx = 2.0 * x[i];
                sum += xx * xx;
                prod *= Math.cos(Math.PI * 10 * xx / Math.sqrt(i + 1));
            }
            return 2.0 * (sum - 2.0 * prod + 2.0) / (double)dim;
        }
        throw new IllegalStateException();
    }

    private double psfunc2(double x, double t1, int dim, int css) {
        ++dim;
        double xy = 2.0 * (x - 0.5);
        if (this.lType == 21) {
            return xy - Math.pow(t1, 0.5 * (double)(this.numberOfVariables + 3 * dim - 8) / (double)(this.numberOfVariables - 2));
        }
        if (this.lType == 22) {
            double theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.numberOfVariables;
            return xy - Math.sin(theta);
        }
        if (this.lType == 23) {
            double theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.numberOfVariables;
            double ra = 0.8 * t1;
            if (css == 1) {
                return xy - ra * Math.cos(theta);
            }
            return xy - ra * Math.sin(theta);
        }
        if (this.lType == 24) {
            double theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.numberOfVariables;
            double ra = 0.8 * t1;
            if (css == 1) {
                return xy - ra * Math.cos(theta / 3.0);
            }
            return xy - ra * Math.sin(theta);
        }
        if (this.lType == 25) {
            double rho = 0.8;
            double phi = Math.PI * t1;
            double theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.numberOfVariables;
            if (css == 1) {
                return xy - rho * Math.sin(phi) * Math.sin(theta);
            }
            if (css == 2) {
                return xy - rho * Math.sin(phi) * Math.cos(theta);
            }
            return xy - rho * Math.cos(phi);
        }
        if (this.lType == 26) {
            double theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.numberOfVariables;
            double ra = 0.3 * t1 * (t1 * Math.cos(4.0 * theta) + 2.0);
            if (css == 1) {
                return xy - ra * Math.cos(theta);
            }
            return xy - ra * Math.sin(theta);
        }
        throw new IllegalStateException();
    }

    private double psfunc3(double x, double t1, double t2, int dim) {
        ++dim;
        double xy = 4.0 * (x - 0.5);
        if (this.lType == 31) {
            double rate = (double)dim / (double)this.numberOfVariables;
            return xy - 4.0 * (t1 * t1 * rate + t2 * (1.0 - rate)) + 2.0;
        }
        if (this.lType == 32) {
            double theta = Math.PI * 2 * t1 + (double)dim * Math.PI / (double)this.numberOfVariables;
            return xy - 2.0 * t2 * Math.sin(theta);
        }
        throw new IllegalStateException();
    }

    private double[] toArray(List<Double> list) {
        double[] array = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double[] evaluate(double[] x_var) {
        double[] y_obj = new double[this.numberOfObjectives];
        if (this.numberOfObjectives == 2) {
            if (this.lType == 21 || this.lType == 22 || this.lType == 23 || this.lType == 24 || this.lType == 26) {
                ArrayList<Double> aa = new ArrayList<Double>();
                ArrayList<Double> bb = new ArrayList<Double>();
                for (int n = 1; n < this.numberOfVariables; ++n) {
                    if (n % 2 == 0) {
                        aa.add(this.psfunc2(x_var[n], x_var[0], n, 1));
                        continue;
                    }
                    bb.add(this.psfunc2(x_var[n], x_var[0], n, 2));
                }
                double g = this.betafunction(this.toArray(aa));
                double h = this.betafunction(this.toArray(bb));
                double[] alpha = this.alphafunction(x_var);
                y_obj[0] = alpha[0] + h;
                y_obj[1] = alpha[1] + g;
                return y_obj;
            } else {
                if (this.lType != 25) throw new IllegalStateException();
                ArrayList<Double> aa = new ArrayList<Double>();
                ArrayList<Double> bb = new ArrayList<Double>();
                for (int n = 1; n < this.numberOfVariables; ++n) {
                    if (n % 3 == 0) {
                        aa.add(this.psfunc2(x_var[n], x_var[0], n, 1));
                        continue;
                    }
                    if (n % 3 == 1) {
                        bb.add(this.psfunc2(x_var[n], x_var[0], n, 2));
                        continue;
                    }
                    double c = this.psfunc2(x_var[n], x_var[0], n, 3);
                    if (n % 2 == 0) {
                        aa.add(c);
                        continue;
                    }
                    bb.add(c);
                }
                double g = this.betafunction(this.toArray(aa));
                double h = this.betafunction(this.toArray(bb));
                double[] alpha = this.alphafunction(x_var);
                y_obj[0] = alpha[0] + h;
                y_obj[1] = alpha[1] + g;
            }
            return y_obj;
        } else {
            if (this.numberOfObjectives != 3) throw new IllegalStateException();
            if (this.lType != 31 && this.lType != 32) throw new IllegalStateException();
            ArrayList<Double> aa = new ArrayList<Double>();
            ArrayList<Double> bb = new ArrayList<Double>();
            ArrayList<Double> cc = new ArrayList<Double>();
            for (int n = 2; n < this.numberOfVariables; ++n) {
                double a = this.psfunc3(x_var[n], x_var[0], x_var[1], n);
                if (n % 3 == 0) {
                    aa.add(a);
                    continue;
                }
                if (n % 3 == 1) {
                    bb.add(a);
                    continue;
                }
                cc.add(a);
            }
            double g = this.betafunction(this.toArray(aa));
            double h = this.betafunction(this.toArray(bb));
            double e = this.betafunction(this.toArray(cc));
            double[] alpha = this.alphafunction(x_var);
            y_obj[0] = alpha[0] + h;
            y_obj[1] = alpha[1] + g;
            y_obj[2] = alpha[2] + e;
        }
        return y_obj;
    }
}

