/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem;

import org.apache.commons.math3.linear.RealMatrix;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.util.Vector;

public class RotatedProblem
implements Problem {
    private final Problem problem;
    private final RealMatrix rotation;
    private final double[] lowerBounds;
    private final double[] upperBounds;
    private final double[] center;

    public RotatedProblem(Problem problem, RealMatrix rotation) {
        this.problem = problem;
        this.rotation = rotation;
        Solution solution = problem.newSolution();
        this.center = new double[this.getNumberOfVariables()];
        this.lowerBounds = new double[this.getNumberOfVariables()];
        this.upperBounds = new double[this.getNumberOfVariables()];
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            RealVariable variable = (RealVariable)solution.getVariable(i);
            this.center[i] = (variable.getLowerBound() + variable.getUpperBound()) / 2.0;
            this.lowerBounds[i] = Math.sqrt(2.0) * (variable.getLowerBound() - this.center[i]);
            this.upperBounds[i] = Math.sqrt(2.0) * (variable.getUpperBound() - this.center[i]);
        }
    }

    @Override
    public String getName() {
        return "Rotated " + this.problem.getName();
    }

    @Override
    public int getNumberOfVariables() {
        return this.problem.getNumberOfVariables();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.problem.getNumberOfObjectives();
    }

    @Override
    public int getNumberOfConstraints() {
        return this.problem.getNumberOfConstraints() + 1;
    }

    @Override
    public void evaluate(Solution solution) {
        int i;
        Solution temp = this.problem.newSolution();
        double[] x = EncodingUtils.getReal(solution);
        x = this.rotation.operate(x);
        x = Vector.add(x, this.center);
        double boundsViolation = 0.0;
        for (i = 0; i < this.getNumberOfVariables(); ++i) {
            RealVariable variable = (RealVariable)temp.getVariable(i);
            if (x[i] < variable.getLowerBound()) {
                boundsViolation += variable.getLowerBound() - x[i];
                variable.setValue(variable.getLowerBound());
                continue;
            }
            if (x[i] > variable.getUpperBound()) {
                boundsViolation += x[i] - variable.getUpperBound();
                variable.setValue(variable.getUpperBound());
                continue;
            }
            variable.setValue(x[i]);
        }
        this.problem.evaluate(temp);
        solution.setObjectives(temp.getObjectives());
        for (i = 0; i < this.problem.getNumberOfConstraints(); ++i) {
            solution.setConstraint(i, temp.getConstraint(i));
        }
        solution.setConstraint(this.problem.getNumberOfConstraints(), boundsViolation);
    }

    @Override
    public Solution newSolution() {
        Solution result = new Solution(this.getNumberOfVariables(), this.getNumberOfObjectives(), this.getNumberOfConstraints());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            result.setVariable(i, new RealVariable(this.lowerBounds[i], this.upperBounds[i]));
        }
        return result;
    }

    @Override
    public void close() {
        this.problem.close();
    }
}

