/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.core.spi.ProblemProvider;
import org.moeaframework.problem.RotatedProblem;
import org.moeaframework.util.RotationMatrixBuilder;

public class RotatedProblems
extends ProblemProvider {
    private static final Pattern PATTERN = Pattern.compile("^(?:(ROT)(?:\\((?:([0-9]+|ALL),)?(\\-?[0-9]+|RAND)\\))?|UNROT)_(.*)$", 2);

    @Override
    public Problem getProblem(String name) {
        Matcher matcher = PATTERN.matcher(name);
        if (matcher.matches()) {
            Problem problem = ProblemFactory.getInstance().getProblem(matcher.group(4));
            RotationMatrixBuilder rotationMatrix = new RotationMatrixBuilder(problem.getNumberOfVariables());
            if (matcher.group(1) != null) {
                String k = matcher.group(2);
                String angle = matcher.group(3);
                if (k == null || k.equalsIgnoreCase("ALL")) {
                    rotationMatrix.rotateAll();
                } else {
                    rotationMatrix.rotateK(Integer.parseInt(k));
                }
                if (angle == null) {
                    rotationMatrix.withThetas(0.7853981633974483);
                } else if (angle.equalsIgnoreCase("RAND")) {
                    rotationMatrix.withRandomThetas();
                } else {
                    rotationMatrix.withThetas(Math.toRadians(Double.parseDouble(angle)));
                }
            }
            return new RotatedProblem(problem, rotationMatrix.create());
        }
        return null;
    }

    @Override
    public NondominatedPopulation getReferenceSet(String name) {
        Matcher matcher = PATTERN.matcher(name);
        if (matcher.matches()) {
            return ProblemFactory.getInstance().getReferenceSet(matcher.group(4));
        }
        return null;
    }
}

