/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public class ScriptedProblem
implements Problem {
    private final Problem internalProblem;
    private final ScriptEngine engine;

    public ScriptedProblem(String script, String name) throws ScriptException {
        this(new StringReader(script), name);
    }

    public ScriptedProblem(Reader reader, String name) throws ScriptException {
        this.engine = this.newScriptEngine(name);
        this.internalProblem = this.createInvocableInstance(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptedProblem(File file) throws ScriptException, IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            this.engine = this.newScriptEngine(file);
            this.internalProblem = this.createInvocableInstance(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private ScriptEngine newScriptEngine(String name) throws ScriptException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(name);
        if (engine == null) {
            throw new ScriptException("no scripting engine for " + name);
        }
        return engine;
    }

    private ScriptEngine newScriptEngine(File file) throws ScriptException {
        String filename = file.getName();
        int index = filename.lastIndexOf(46);
        if (index < 0 || index >= filename.length() - 1) {
            throw new ScriptException("file has no extension");
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        String extension = filename.substring(index + 1);
        ScriptEngine engine = manager.getEngineByExtension(extension);
        if (engine == null) {
            throw new ScriptException("no scripting engine for extension ." + extension);
        }
        return engine;
    }

    private Problem createInvocableInstance(Reader reader) throws ScriptException {
        Problem problem = null;
        if (this.engine instanceof Invocable) {
            this.engine.eval(reader);
            problem = ((Invocable)((Object)this.engine)).getInterface(Problem.class);
        }
        if (problem == null) {
            throw new ScriptException("scripting engine not invocable");
        }
        return problem;
    }

    @Override
    public String getName() {
        return this.internalProblem.getName();
    }

    @Override
    public int getNumberOfVariables() {
        return this.internalProblem.getNumberOfVariables();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.internalProblem.getNumberOfObjectives();
    }

    @Override
    public int getNumberOfConstraints() {
        return this.internalProblem.getNumberOfConstraints();
    }

    @Override
    public void evaluate(Solution solution) {
        this.internalProblem.evaluate(solution);
    }

    @Override
    public Solution newSolution() {
        return this.internalProblem.newSolution();
    }

    @Override
    public void close() {
        this.internalProblem.close();
    }
}

