/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem;

import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public class TimingProblem
implements Problem {
    private final Problem problem;
    private double time;

    public TimingProblem(Problem problem) {
        this.problem = problem;
    }

    @Override
    public String getName() {
        return this.problem.getName();
    }

    @Override
    public int getNumberOfVariables() {
        return this.problem.getNumberOfVariables();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.problem.getNumberOfObjectives();
    }

    @Override
    public int getNumberOfConstraints() {
        return this.problem.getNumberOfConstraints();
    }

    @Override
    public void evaluate(Solution solution) {
        long start = System.nanoTime();
        this.problem.evaluate(solution);
        long end = System.nanoTime();
        this.time += (double)(end - start) / 1.0E9;
    }

    @Override
    public Solution newSolution() {
        return this.problem.newSolution();
    }

    public void clear() {
        this.time = 0.0;
    }

    public double getTime() {
        return this.time;
    }

    @Override
    public void close() {
        this.problem.close();
    }
}

