/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.WFG;

import org.moeaframework.problem.WFG.Misc;

class FrameworkFunctions {
    private FrameworkFunctions() {
    }

    public static double[] normalize_z(double[] z, double[] z_max) {
        double[] result = new double[z.length];
        for (int i = 0; i < z.length; ++i) {
            assert (z[i] >= 0.0 && z[i] <= z_max[i]);
            assert (z_max[i] > 0.0);
            result[i] = z[i] / z_max[i];
        }
        return result;
    }

    public static double[] calculate_x(double[] t_p, int[] A) {
        assert (Misc.vector_in_01(t_p));
        assert (t_p.length != 0);
        assert (A.length == t_p.length - 1);
        double[] result = new double[t_p.length];
        for (int i = 0; i < t_p.length - 1; ++i) {
            assert (A[i] == 0 || A[i] == 1);
            double tmp = Math.max(t_p[t_p.length - 1], (double)A[i]);
            result[i] = tmp * (t_p[i] - 0.5) + 0.5;
        }
        result[t_p.length - 1] = t_p[t_p.length - 1];
        return result;
    }

    public static double[] calculate_f(double D, double[] x, double[] h, double[] S) {
        assert (D > 0.0);
        assert (Misc.vector_in_01(x));
        assert (Misc.vector_in_01(h));
        assert (x.length == h.length);
        assert (h.length == S.length);
        double[] result = new double[h.length];
        for (int i = 0; i < h.length; ++i) {
            assert (S[i] > 0.0);
            result[i] = D * x[x.length - 1] + S[i] * h[i];
        }
        return result;
    }
}

