/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.WFG;

import org.moeaframework.problem.WFG.Shapes;
import org.moeaframework.problem.WFG.Transitions;

class Problems {
    private Problems() {
    }

    private static boolean ArgsOk(double[] z, int k, int M) {
        int n = z.length;
        return k >= 1 && k < n && M >= 2 && k % (M - 1) == 0;
    }

    private static double[] WFG_normalize_z(double[] z) {
        double[] result = new double[z.length];
        for (int i = 0; i < z.length; ++i) {
            double bound = 2.0 * (double)(i + 1);
            assert (z[i] >= 0.0);
            assert (z[i] <= bound);
            result[i] = z[i] / bound;
        }
        return result;
    }

    public static double[] WFG1(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG1_t1(y, k);
        y = Transitions.WFG1_t2(y, k);
        y = Transitions.WFG1_t3(y);
        y = Transitions.WFG1_t4(y, k, M);
        return Shapes.WFG1_shape(y);
    }

    public static double[] WFG2(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        assert ((z.length - k) % 2 == 0);
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG1_t1(y, k);
        y = Transitions.WFG2_t2(y, k);
        y = Transitions.WFG2_t3(y, k, M);
        return Shapes.WFG2_shape(y);
    }

    public static double[] WFG3(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        assert ((z.length - k) % 2 == 0);
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG1_t1(y, k);
        y = Transitions.WFG2_t2(y, k);
        y = Transitions.WFG2_t3(y, k, M);
        return Shapes.WFG3_shape(y);
    }

    public static double[] WFG4(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG4_t1(y);
        y = Transitions.WFG2_t3(y, k, M);
        return Shapes.WFG4_shape(y);
    }

    public static double[] WFG5(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG5_t1(y);
        y = Transitions.WFG2_t3(y, k, M);
        return Shapes.WFG4_shape(y);
    }

    public static double[] WFG6(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG1_t1(y, k);
        y = Transitions.WFG6_t2(y, k, M);
        return Shapes.WFG4_shape(y);
    }

    public static double[] WFG7(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG7_t1(y, k);
        y = Transitions.WFG1_t1(y, k);
        y = Transitions.WFG2_t3(y, k, M);
        return Shapes.WFG4_shape(y);
    }

    public static double[] WFG8(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG8_t1(y, k);
        y = Transitions.WFG1_t1(y, k);
        y = Transitions.WFG2_t3(y, k, M);
        return Shapes.WFG4_shape(y);
    }

    public static double[] WFG9(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = Problems.WFG_normalize_z(z);
        y = Transitions.WFG9_t1(y);
        y = Transitions.WFG9_t2(y, k);
        y = Transitions.WFG6_t2(y, k, M);
        return Shapes.WFG4_shape(y);
    }

    public static double[] I1(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = z;
        y = Transitions.I1_t2(y, k);
        y = Transitions.I1_t3(y, k, M);
        return Shapes.I1_shape(y);
    }

    public static double[] I2(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = z;
        y = Transitions.I2_t1(y);
        y = Transitions.I1_t2(y, k);
        y = Transitions.I1_t3(y, k, M);
        return Shapes.I1_shape(y);
    }

    public static double[] I3(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = z;
        y = Transitions.I3_t1(y);
        y = Transitions.I1_t2(y, k);
        y = Transitions.I1_t3(y, k, M);
        return Shapes.I1_shape(y);
    }

    public static double[] I4(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = z;
        y = Transitions.I1_t2(y, k);
        y = Transitions.I4_t3(y, k, M);
        return Shapes.I1_shape(y);
    }

    public static double[] I5(double[] z, int k, int M) {
        assert (Problems.ArgsOk(z, k, M));
        double[] y = z;
        y = Transitions.I3_t1(y);
        y = Transitions.I1_t2(y, k);
        y = Transitions.I4_t3(y, k, M);
        return Shapes.I1_shape(y);
    }
}

