/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.WFG;

import org.moeaframework.problem.WFG.Misc;

class ShapeFunctions {
    private ShapeFunctions() {
    }

    public static boolean shape_args_ok(double[] x, int m) {
        return Misc.vector_in_01(x) && m >= 1 && m <= x.length;
    }

    public static double linear(double[] x, int m) {
        assert (ShapeFunctions.shape_args_ok(x, m));
        int M = x.length;
        double result = 1.0;
        for (int i = 1; i <= M - m; ++i) {
            result *= x[i - 1];
        }
        if (m != 1) {
            result *= 1.0 - x[M - m];
        }
        return Misc.correct_to_01(result);
    }

    public static double convex(double[] x, int m) {
        assert (ShapeFunctions.shape_args_ok(x, m));
        int M = x.length;
        double result = 1.0;
        for (int i = 1; i <= M - m; ++i) {
            result *= 1.0 - Math.cos(x[i - 1] * Math.PI / 2.0);
        }
        if (m != 1) {
            result *= 1.0 - Math.sin(x[M - m] * Math.PI / 2.0);
        }
        return Misc.correct_to_01(result);
    }

    public static double concave(double[] x, int m) {
        assert (ShapeFunctions.shape_args_ok(x, m));
        int M = x.length;
        double result = 1.0;
        for (int i = 1; i <= M - m; ++i) {
            result *= Math.sin(x[i - 1] * Math.PI / 2.0);
        }
        if (m != 1) {
            result *= Math.cos(x[M - m] * Math.PI / 2.0);
        }
        return Misc.correct_to_01(result);
    }

    public static double mixed(double[] x, int A, double alpha) {
        assert (Misc.vector_in_01(x));
        assert (x.length != 0);
        assert (A >= 1);
        assert (alpha > 0.0);
        double tmp = 2.0 * (double)A * Math.PI;
        return Misc.correct_to_01(Math.pow(1.0 - x[0] - Math.cos(tmp * x[0] + 1.5707963267948966) / tmp, alpha));
    }

    public static double disc(double[] x, int A, double alpha, double beta) {
        assert (Misc.vector_in_01(x));
        assert (x.length != 0);
        assert (A >= 1);
        assert (alpha > 0.0);
        assert (beta > 0.0);
        double tmp = (double)A * Math.pow(x[0], beta) * Math.PI;
        return Misc.correct_to_01(1.0 - Math.pow(x[0], alpha) * Math.pow(Math.cos(tmp), 2.0));
    }
}

