/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.WFG;

import java.util.Arrays;
import org.moeaframework.problem.WFG.FrameworkFunctions;
import org.moeaframework.problem.WFG.Misc;
import org.moeaframework.problem.WFG.ShapeFunctions;

class Shapes {
    private Shapes() {
    }

    private static int[] WFG_create_A(int M, boolean degenerate) {
        assert (M >= 2);
        if (degenerate) {
            int[] A = new int[M - 1];
            A[0] = 1;
            return A;
        }
        int[] A = new int[M - 1];
        Arrays.fill(A, 1);
        return A;
    }

    private static double[] WFG_calculate_f(double[] x, double[] h) {
        assert (Misc.vector_in_01(x));
        assert (Misc.vector_in_01(h));
        assert (x.length == h.length);
        int M = h.length;
        double[] S = new double[M];
        for (int m = 1; m <= M; ++m) {
            S[m - 1] = (double)m * 2.0;
        }
        return FrameworkFunctions.calculate_f(1.0, x, h, S);
    }

    public static double[] WFG1_shape(double[] t_p) {
        assert (Misc.vector_in_01(t_p));
        assert (t_p.length >= 2);
        int M = t_p.length;
        int[] A = Shapes.WFG_create_A(M, false);
        double[] x = FrameworkFunctions.calculate_x(t_p, A);
        double[] h = new double[M];
        for (int m = 1; m <= M - 1; ++m) {
            h[m - 1] = ShapeFunctions.convex(x, m);
        }
        h[M - 1] = ShapeFunctions.mixed(x, 5, 1.0);
        return Shapes.WFG_calculate_f(x, h);
    }

    public static double[] WFG2_shape(double[] t_p) {
        assert (Misc.vector_in_01(t_p));
        assert (t_p.length >= 2);
        int M = t_p.length;
        int[] A = Shapes.WFG_create_A(M, false);
        double[] x = FrameworkFunctions.calculate_x(t_p, A);
        double[] h = new double[M];
        for (int m = 1; m <= M - 1; ++m) {
            h[m - 1] = ShapeFunctions.convex(x, m);
        }
        h[M - 1] = ShapeFunctions.disc(x, 5, 1.0, 1.0);
        return Shapes.WFG_calculate_f(x, h);
    }

    public static double[] WFG3_shape(double[] t_p) {
        assert (Misc.vector_in_01(t_p));
        assert (t_p.length >= 2);
        int M = t_p.length;
        int[] A = Shapes.WFG_create_A(M, true);
        double[] x = FrameworkFunctions.calculate_x(t_p, A);
        double[] h = new double[M];
        for (int m = 1; m <= M; ++m) {
            h[m - 1] = ShapeFunctions.linear(x, m);
        }
        return Shapes.WFG_calculate_f(x, h);
    }

    public static double[] WFG4_shape(double[] t_p) {
        assert (Misc.vector_in_01(t_p));
        assert (t_p.length >= 2);
        int M = t_p.length;
        int[] A = Shapes.WFG_create_A(M, false);
        double[] x = FrameworkFunctions.calculate_x(t_p, A);
        double[] h = new double[M];
        for (int m = 1; m <= M; ++m) {
            h[m - 1] = ShapeFunctions.concave(x, m);
        }
        return Shapes.WFG_calculate_f(x, h);
    }

    public static double[] I1_shape(double[] t_p) {
        assert (Misc.vector_in_01(t_p));
        assert (t_p.length >= 2);
        int M = t_p.length;
        int[] A = Shapes.WFG_create_A(M, false);
        double[] x = FrameworkFunctions.calculate_x(t_p, A);
        double[] h = new double[M];
        for (int m = 1; m <= M; ++m) {
            h[m - 1] = ShapeFunctions.concave(x, m);
        }
        double[] S = new double[M];
        Arrays.fill(S, 1.0);
        return FrameworkFunctions.calculate_f(1.0, x, h, S);
    }
}

