/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.WFG;

import java.util.Arrays;
import org.moeaframework.core.PRNG;
import org.moeaframework.problem.WFG.TransFunctions;

class Solutions {
    private Solutions() {
    }

    public static double[] WFG_1_random_soln(int k, int l) {
        int i;
        double[] result = new double[k + l];
        for (i = 0; i < k; ++i) {
            result[i] = Math.pow(PRNG.nextDouble(), 50.0);
        }
        for (i = k; i < k + l; ++i) {
            result[i] = 0.35;
        }
        for (i = 0; i < k + l; ++i) {
            int n = i;
            result[n] = result[n] * (2.0 * (double)(i + 1));
        }
        return result;
    }

    public static double[] WFG_2_thru_7_random_soln(int k, int l) {
        int i;
        double[] result = new double[k + l];
        for (i = 0; i < k; ++i) {
            result[i] = PRNG.nextDouble();
        }
        for (i = k; i < k + l; ++i) {
            result[i] = 0.35;
        }
        for (i = 0; i < k + l; ++i) {
            int n = i;
            result[n] = result[n] * (2.0 * (double)(i + 1));
        }
        return result;
    }

    public static double[] WFG_8_random_soln(int k, int l) {
        int i;
        double[] result = new double[k + l];
        for (i = 0; i < k; ++i) {
            result[i] = PRNG.nextDouble();
        }
        for (i = k; i < k + l; ++i) {
            double[] w = new double[k + l];
            Arrays.fill(w, 1.0);
            double u = TransFunctions.r_sum(result, w);
            double tmp1 = Math.abs(Math.floor(0.5 - u) + 0.0196078431372549);
            double tmp2 = 0.02 + 49.98 * (0.0196078431372549 - (1.0 - 2.0 * u) * tmp1);
            result[i] = Math.pow(0.35, Math.pow(tmp2, -1.0));
        }
        for (i = 0; i < k + l; ++i) {
            int n = i;
            result[n] = result[n] * (2.0 * (double)(i + 1));
        }
        return result;
    }

    public static double[] WFG_9_random_soln(int k, int l) {
        int i;
        double[] result = new double[k + l];
        for (i = 0; i < k; ++i) {
            result[i] = PRNG.nextDouble();
        }
        result[k + l - 1] = 0.35;
        for (i = k + l - 2; i >= k; --i) {
            double[] result_sub = new double[k + l - i - 1];
            for (int j = i + 1; j < k + l; ++j) {
                result_sub[j - i - 1] = result[j];
            }
            double[] w = new double[result_sub.length];
            Arrays.fill(w, 1.0);
            double tmp1 = TransFunctions.r_sum(result_sub, w);
            result[i] = Math.pow(0.35, Math.pow(0.02 + 1.96 * tmp1, -1.0));
        }
        for (i = 0; i < k + l; ++i) {
            int n = i;
            result[n] = result[n] * (2.0 * (double)(i + 1));
        }
        return result;
    }

    public static double[] I1_random_soln(int k, int l) {
        int i;
        double[] result = new double[k + l];
        for (i = 0; i < k; ++i) {
            result[i] = PRNG.nextDouble();
        }
        for (i = k; i < k + l; ++i) {
            result[i] = 0.35;
        }
        return result;
    }

    public static double[] I2_random_soln(int k, int l) {
        int i;
        double[] result = new double[k + l];
        for (i = 0; i < k; ++i) {
            result[i] = PRNG.nextDouble();
        }
        result[k + l - 1] = 0.35;
        for (i = k + l - 2; i >= k; --i) {
            double[] result_sub = new double[k + l - i - 1];
            for (int j = i + 1; j < k + l; ++j) {
                result_sub[j - i - 1] = result[j];
            }
            double[] w = new double[result_sub.length];
            Arrays.fill(w, 1.0);
            double tmp1 = TransFunctions.r_sum(result_sub, w);
            result[i] = Math.pow(0.35, Math.pow(0.02 + 1.96 * tmp1, -1.0));
        }
        return result;
    }

    public static double[] I3_random_soln(int k, int l) {
        int i;
        double[] result = new double[k + l];
        for (i = 0; i < k; ++i) {
            result[i] = PRNG.nextDouble();
        }
        for (i = k; i < k + l; ++i) {
            double[] w = new double[k + l];
            Arrays.fill(w, 1.0);
            double u = TransFunctions.r_sum(result, w);
            double tmp1 = Math.abs(Math.floor(0.5 - u) + 0.0196078431372549);
            double tmp2 = 0.02 + 49.98 * (0.0196078431372549 - (1.0 - 2.0 * u) * tmp1);
            result[i] = Math.pow(0.35, Math.pow(tmp2, -1.0));
        }
        return result;
    }

    public static double[] I4_random_soln(int k, int l) {
        return Solutions.I1_random_soln(k, l);
    }

    public static double[] I5_random_soln(int k, int l) {
        return Solutions.I3_random_soln(k, l);
    }
}

