/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.ZDT;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.BinaryVariable;
import org.moeaframework.problem.ZDT.ZDT;

public class ZDT5
extends ZDT {
    public ZDT5() {
        super(11);
    }

    public ZDT5(int numberOfVariables) {
        super(numberOfVariables);
    }

    @Override
    public void evaluate(Solution solution) {
        double f = 1 + ((BinaryVariable)solution.getVariable(0)).cardinality();
        double g = 0.0;
        for (int i = 1; i < this.numberOfVariables; ++i) {
            g += this.v(((BinaryVariable)solution.getVariable(i)).cardinality());
        }
        double h = 1.0 / f;
        solution.setObjective(0, f);
        solution.setObjective(1, g * h);
    }

    private double v(int cardinality) {
        return cardinality < 5 ? (double)(2 + cardinality) : 1.0;
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, 2);
        solution.setVariable(0, new BinaryVariable(30));
        for (int i = 1; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new BinaryVariable(5));
        }
        return solution;
    }
}

