/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.ZDT;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.ZDT.ZDT;

public class ZDT6
extends ZDT {
    public ZDT6() {
        this(10);
    }

    public ZDT6(int numberOfVariables) {
        super(numberOfVariables);
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double f = 1.0 - Math.exp(-4.0 * x[0]) * Math.pow(Math.sin(Math.PI * 6 * x[0]), 6.0);
        double g = 0.0;
        for (int i = 1; i < this.numberOfVariables; ++i) {
            g += x[i];
        }
        g = 1.0 + 9.0 * Math.pow(g / (double)(this.numberOfVariables - 1), 0.25);
        double h = 1.0 - Math.pow(f / g, 2.0);
        solution.setObjective(0, f);
        solution.setObjective(1, g * h);
    }
}

