/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.AnalyticalProblem;

public class Binh4
extends AbstractProblem
implements AnalyticalProblem {
    public Binh4() {
        super(2, 3, 2);
    }

    @Override
    public void evaluate(Solution solution) {
        double x = EncodingUtils.getReal(solution.getVariable(0));
        double y = EncodingUtils.getReal(solution.getVariable(1));
        double f1 = 1.5 - x * (1.0 - y);
        double f2 = 2.25 - x * (1.0 - Math.pow(y, 2.0));
        double f3 = 2.625 - x * (1.0 - Math.pow(y, 3.0));
        double c1 = -Math.pow(x, 2.0) - Math.pow(y - 0.5, 2.0) + 9.0;
        double c2 = Math.pow(x - 1.0, 2.0) + Math.pow(y - 0.5, 2.0) - 6.25;
        solution.setObjective(0, f1);
        solution.setObjective(1, f2);
        solution.setObjective(2, f3);
        solution.setConstraint(0, c1 <= 0.0 ? 0.0 : c1);
        solution.setConstraint(1, c2 <= 0.0 ? 0.0 : c2);
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(2, 3, 2);
        solution.setVariable(0, EncodingUtils.newReal(-10.0, 10.0));
        solution.setVariable(1, EncodingUtils.newReal(-10.0, 10.0));
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution = this.newSolution();
        EncodingUtils.setReal(solution.getVariable(0), 3.0);
        EncodingUtils.setReal(solution.getVariable(1), 0.5);
        this.evaluate(solution);
        return solution;
    }
}

