/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.AnalyticalProblem;

public class Fonseca2
extends AbstractProblem
implements AnalyticalProblem {
    public Fonseca2() {
        this(3);
    }

    public Fonseca2(int numberOfVariables) {
        super(numberOfVariables, 2);
    }

    @Override
    public void evaluate(Solution solution) {
        double[] x = EncodingUtils.getReal(solution);
        double f1 = 0.0;
        double f2 = 0.0;
        for (int i = 0; i < this.numberOfVariables; ++i) {
            f1 += Math.pow(x[i] - 1.0 / Math.sqrt(this.numberOfVariables), 2.0);
            f2 += Math.pow(x[i] + 1.0 / Math.sqrt(this.numberOfVariables), 2.0);
        }
        f1 = 1.0 - Math.exp(-f1);
        f2 = 1.0 - Math.exp(-f2);
        solution.setObjective(0, f1);
        solution.setObjective(1, f2);
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, 2);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, EncodingUtils.newReal(-4.0, 4.0));
        }
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution = this.newSolution();
        double x = PRNG.nextDouble(-1.0 / Math.sqrt(this.numberOfVariables), 1.0 / Math.sqrt(this.numberOfVariables));
        for (int i = 0; i < this.numberOfVariables; ++i) {
            EncodingUtils.setReal(solution.getVariable(i), x);
        }
        this.evaluate(solution);
        return solution;
    }
}

