/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.AnalyticalProblem;

public class Jimenez
extends AbstractProblem
implements AnalyticalProblem {
    public Jimenez() {
        super(2, 2, 4);
    }

    @Override
    public void evaluate(Solution solution) {
        double x = EncodingUtils.getReal(solution.getVariable(0));
        double y = EncodingUtils.getReal(solution.getVariable(1));
        double f1 = 5.0 * x + 3.0 * y;
        double f2 = 2.0 * x + 8.0 * y;
        double c1 = x + 4.0 * y - 100.0;
        double c2 = 3.0 * x + 2.0 * y - 150.0;
        double c3 = 200.0 - 5.0 * x - 3.0 * y;
        double c4 = 75.0 - 2.0 * x - 8.0 * y;
        solution.setObjective(0, -f1);
        solution.setObjective(1, -f2);
        solution.setConstraint(0, c1 <= 0.0 ? 0.0 : c1);
        solution.setConstraint(1, c2 <= 0.0 ? 0.0 : c2);
        solution.setConstraint(2, c3 <= 0.0 ? 0.0 : c3);
        solution.setConstraint(3, c4 <= 0.0 ? 0.0 : c4);
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(2, 2, 4);
        solution.setVariable(0, EncodingUtils.newReal(0.0, 50.0));
        solution.setVariable(1, EncodingUtils.newReal(0.0, 50.0));
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution = this.newSolution();
        double p = PRNG.nextDouble(0.0, 1.0);
        EncodingUtils.setReal(solution.getVariable(0), 40.0 + 10.0 * p);
        EncodingUtils.setReal(solution.getVariable(1), 15.0 - 15.0 * p);
        this.evaluate(solution);
        return solution;
    }
}

