/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.AbstractProblem;

public class Kursawe
extends AbstractProblem {
    private final double lowerBound;
    private final double upperBound;

    public Kursawe() {
        this(3);
    }

    public Kursawe(int numberOfVariables) {
        this(numberOfVariables, -5.0, 5.0);
    }

    public Kursawe(int numberOfVariables, double lowerBound, double upperBound) {
        super(numberOfVariables, 2);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public void evaluate(Solution solution) {
        int i;
        double[] x = EncodingUtils.getReal(solution);
        double f1 = 0.0;
        double f2 = 0.0;
        for (i = 0; i < this.numberOfVariables - 1; ++i) {
            f1 += -10.0 * Math.exp(-0.2 * Math.sqrt(Math.pow(x[i], 2.0) + Math.pow(x[i + 1], 2.0)));
        }
        for (i = 0; i < this.numberOfVariables; ++i) {
            f2 += Math.pow(Math.abs(x[i]), 0.8) + 5.0 * Math.sin(Math.pow(x[i], 3.0));
        }
        solution.setObjective(0, f1);
        solution.setObjective(1, f2);
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(this.numberOfVariables, 2);
        for (int i = 0; i < this.numberOfVariables; ++i) {
            solution.setVariable(i, new RealVariable(this.lowerBound, this.upperBound));
        }
        return solution;
    }
}

