/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.AnalyticalProblem;

public class Laumanns
extends AbstractProblem
implements AnalyticalProblem {
    public Laumanns() {
        super(2, 2);
    }

    @Override
    public void evaluate(Solution solution) {
        double x = EncodingUtils.getReal(solution.getVariable(0));
        double y = EncodingUtils.getReal(solution.getVariable(1));
        double f1 = Math.pow(x, 2.0) + Math.pow(y, 2.0);
        double f2 = Math.pow(x + 2.0, 2.0) + Math.pow(y, 2.0);
        solution.setObjective(0, f1);
        solution.setObjective(1, f2);
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(2, 2);
        solution.setVariable(0, EncodingUtils.newReal(-50.0, 50.0));
        solution.setVariable(1, EncodingUtils.newReal(-50.0, 50.0));
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution = this.newSolution();
        EncodingUtils.setReal(solution.getVariable(0), PRNG.nextDouble(-2.0, 0.0));
        EncodingUtils.setReal(solution.getVariable(1), 0.0);
        this.evaluate(solution);
        return solution;
    }
}

