/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.problem.misc;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.problem.AbstractProblem;
import org.moeaframework.problem.AnalyticalProblem;

public class Murata
extends AbstractProblem
implements AnalyticalProblem {
    public Murata() {
        super(2, 2);
    }

    @Override
    public void evaluate(Solution solution) {
        double x = EncodingUtils.getReal(solution.getVariable(0));
        double y = EncodingUtils.getReal(solution.getVariable(1));
        double f1 = 2.0 * Math.sqrt(x);
        double f2 = x * (1.0 - y) + 5.0;
        solution.setObjective(0, f1);
        solution.setObjective(1, f2);
    }

    @Override
    public Solution newSolution() {
        Solution solution = new Solution(2, 2);
        solution.setVariable(0, EncodingUtils.newReal(1.0, 4.0));
        solution.setVariable(1, EncodingUtils.newReal(1.0, 2.0));
        return solution;
    }

    @Override
    public Solution generate() {
        Solution solution = this.newSolution();
        EncodingUtils.setReal(solution.getVariable(0), PRNG.nextDouble(1.0, 4.0));
        EncodingUtils.setReal(solution.getVariable(1), 2.0);
        this.evaluate(solution);
        return solution;
    }
}

